/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes;

import com.github.sommeri.less4j.core.compiler.scopes.FullMixinDefinition;
import com.github.sommeri.less4j.core.compiler.scopes.MixinsDefinitionsStorage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class Placeholder
implements Cloneable {
    private MixinsDefinitionsStorage owner;
    private Map<String, FullMixinDefinition> nextMixin = new HashMap<String, FullMixinDefinition>();

    protected Placeholder(MixinsDefinitionsStorage owner) {
        this.owner = owner;
    }

    public boolean knowPosition(String name) {
        return this.nextMixin.containsKey(name);
    }

    public void setPosition(String name, FullMixinDefinition mixin) {
        this.nextMixin.put(name, mixin);
    }

    public void addToSelf(String name, List<FullMixinDefinition> values) {
        List<FullMixinDefinition> storedList = this.owner.getStoredList(name);
        int position = this.position(name, storedList);
        storedList.addAll(position, values);
    }

    private int position(String name, List<FullMixinDefinition> storedList) {
        FullMixinDefinition mixin = this.nextMixin.get(name);
        return this.position(mixin, storedList);
    }

    protected int position(FullMixinDefinition mixin, List<FullMixinDefinition> storedList) {
        if (mixin == null) {
            return storedList.size();
        }
        return storedList.indexOf(mixin);
    }

    protected Placeholder clone() {
        try {
            Placeholder clone = (Placeholder)super.clone();
            clone.nextMixin = new HashMap<String, FullMixinDefinition>(this.nextMixin);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible state.");
        }
    }

    protected Placeholder clone(MixinsDefinitionsStorage owner) {
        Placeholder clone = this.clone();
        clone.owner = owner;
        return clone;
    }
}

