/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.SelectorOperator;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class SelectorAttribute
extends ElementSubsequent {
    private String name;
    private SelectorOperator operator;
    private Expression value;

    public SelectorAttribute(HiddenTokenAwareTree token, String name) {
        this(token, name, new SelectorOperator(new HiddenTokenAwareTree(token.getSource()), SelectorOperator.Operator.NONE), null);
    }

    public SelectorAttribute(HiddenTokenAwareTree token, String name, SelectorOperator operator, Expression value) {
        super(token);
        this.name = name;
        this.operator = operator;
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public void extendName(String extension) {
        this.setName(this.getName() + extension);
    }

    public SelectorOperator getOperator() {
        return this.operator;
    }

    public void setOperator(SelectorOperator operator) {
        this.operator = operator;
    }

    public Expression getValue() {
        return this.value;
    }

    public void setValue(Expression value) {
        this.value = value;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.SELECTOR_ATTRIBUTE;
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.operator, this.value);
    }

    @Override
    public SelectorAttribute clone() {
        SelectorAttribute result = (SelectorAttribute)super.clone();
        result.operator = this.operator == null ? null : this.operator.clone();
        result.value = this.value == null ? null : this.value.clone();
        result.configureParentToAllChilds();
        return result;
    }

    @Override
    public boolean isInterpolated() {
        return false;
    }
}

