/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionEvaluator;
import com.github.sommeri.less4j.core.compiler.expressions.MatchRange;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.InStringCssPrinter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringInterpolator {
    private static final Pattern STR_INTERPOLATION = Pattern.compile("@\\{([^\\{\\}@])*\\}");

    public String replaceInterpolatedVariables(String originalValue, ExpressionEvaluator expressionEvaluator, HiddenTokenAwareTree technicalUnderlying) {
        StringBuilder result = new StringBuilder();
        List<MatchRange> matches = this.findMatches(originalValue);
        int lastEnd = 0;
        for (MatchRange matchRange : matches) {
            result.append(originalValue.substring(lastEnd, matchRange.getFrom()));
            result.append(this.evaluate(expressionEvaluator, technicalUnderlying, matchRange));
            lastEnd = matchRange.getTo();
        }
        if (lastEnd < originalValue.length()) {
            result.append(originalValue.substring(lastEnd));
        }
        return result.toString();
    }

    private String evaluate(ExpressionEvaluator expressionEvaluator, HiddenTokenAwareTree technicalUnderlying, MatchRange matchRange) {
        Expression value = expressionEvaluator.evaluateIfPresent(new Variable(technicalUnderlying, matchRange.getVariableName()));
        if (value != null && value instanceof CssString) {
            CssString string = (CssString)value;
            return this.replaceInterpolatedVariables(string.getValue(), expressionEvaluator, technicalUnderlying);
        }
        if (value == null) {
            return matchRange.getFullMatch();
        }
        InStringCssPrinter builder = new InStringCssPrinter();
        builder.append(value);
        String replacement = builder.toString();
        return replacement;
    }

    private List<MatchRange> findMatches(String originalValue) {
        ArrayList<MatchRange> result = new ArrayList<MatchRange>();
        Matcher matcher = STR_INTERPOLATION.matcher(originalValue);
        while (matcher.find()) {
            result.add(this.createMatchRange(matcher));
        }
        return result;
    }

    private MatchRange createMatchRange(Matcher matcher) {
        String group = matcher.group();
        return new MatchRange(matcher.start(), matcher.end(), "@" + group.substring(2, group.length() - 1), group);
    }
}

