/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.reader;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.kongchen.swagger.docgen.GenerateException;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.jackson.ModelResolver;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.core.annotation.AnnotationUtils;

public class ModelModifier
extends ModelResolver {
    private Map<Type, Type> modelSubtitutes = new HashMap<Type, Type>();
    List<String> apiModelPropertyAccessExclusions = new ArrayList<String>();

    public ModelModifier(ObjectMapper mapper) {
        super(mapper);
    }

    public void addModelSubstitute(String fromClass, String toClass) throws GenerateException {
        try {
            JavaType type = this._mapper.constructType(Class.forName(fromClass));
            JavaType toType = this._mapper.constructType(Class.forName(toClass));
            this.modelSubtitutes.put((Type)type, (Type)toType);
        }
        catch (ClassNotFoundException e) {
            throw new GenerateException(e);
        }
    }

    public List<String> getApiModelPropertyAccessExclusions() {
        return this.apiModelPropertyAccessExclusions;
    }

    public void setApiModelPropertyAccessExclusions(List<String> apiModelPropertyAccessExclusions) {
        this.apiModelPropertyAccessExclusions = apiModelPropertyAccessExclusions;
    }

    public Property resolveProperty(Type type, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> chain) {
        if (this.modelSubtitutes.containsKey(type)) {
            return super.resolveProperty(this.modelSubtitutes.get(type), context, annotations, chain);
        }
        return super.resolveProperty(type, context, annotations, chain);
    }

    public Model resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        if (this.modelSubtitutes.containsKey(type)) {
            return super.resolve(this.modelSubtitutes.get(type), context, chain);
        }
        return super.resolve(type, context, chain);
    }

    public Model resolve(JavaType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        Model model = super.resolve(type, context, chain);
        if (this.apiModelPropertyAccessExclusions == null || this.apiModelPropertyAccessExclusions.isEmpty()) {
            return model;
        }
        Class cls = type.getRawClass();
        for (Method method : cls.getDeclaredMethods()) {
            ApiModelProperty apiModelPropertyAnnotation = (ApiModelProperty)AnnotationUtils.findAnnotation((Method)method, ApiModelProperty.class);
            if (!(apiModelPropertyAnnotation instanceof ApiModelProperty)) continue;
            String apiModelPropertyAccess = apiModelPropertyAnnotation.access();
            String apiModelPropertyName = apiModelPropertyAnnotation.name();
            if (apiModelPropertyAccess.isEmpty() || apiModelPropertyName.isEmpty() || !this.apiModelPropertyAccessExclusions.contains(apiModelPropertyAccess)) continue;
            model.getProperties().remove(apiModelPropertyName);
        }
        return model;
    }
}

