/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.kongchen.swagger.docgen.GenerateException;
import com.github.kongchen.swagger.docgen.LogAdapter;
import com.github.kongchen.swagger.docgen.TemplatePath;
import com.github.kongchen.swagger.docgen.Utils;
import com.github.kongchen.swagger.docgen.mavenplugin.ApiSource;
import com.github.kongchen.swagger.docgen.reader.ModelSubstitute;
import com.wordnik.swagger.converter.ModelConverter;
import com.wordnik.swagger.converter.ModelConverters;
import com.wordnik.swagger.models.Scheme;
import com.wordnik.swagger.models.Swagger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;

public abstract class AbstractDocumentSource {
    protected final ApiSource apiSource;
    protected final LogAdapter LOG;
    private final String outputPath;
    private final String templatePath;
    private final String swaggerPath;
    private final String modelSubstitute;
    protected Swagger swagger;
    private ObjectMapper mapper = new ObjectMapper();
    private boolean isSorted = false;
    protected String swaggerSchemaConverter;

    public AbstractDocumentSource(LogAdapter log, ApiSource apiSource) {
        this.LOG = log;
        this.outputPath = apiSource.getOutputPath();
        this.templatePath = apiSource.getTemplatePath();
        this.swaggerPath = apiSource.getSwaggerDirectory();
        this.modelSubstitute = apiSource.getModelSubstitute();
        this.swagger = new Swagger();
        if (apiSource.getSchemes() != null) {
            if (apiSource.getSchemes().contains(",")) {
                for (String scheme : apiSource.getSchemes().split(",")) {
                    this.swagger.scheme(Scheme.forValue((String)scheme));
                }
            } else {
                this.swagger.scheme(Scheme.forValue((String)apiSource.getSchemes()));
            }
        }
        this.swagger.setHost(apiSource.getHost());
        this.swagger.setInfo(apiSource.getInfo());
        this.swagger.setBasePath(apiSource.getBasePath());
        this.apiSource = apiSource;
    }

    public abstract void loadDocuments() throws Exception, GenerateException;

    public void toSwaggerDocuments(String swaggerUIDocBasePath) throws GenerateException {
        File dir;
        this.mapper.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        if (this.swaggerPath == null) {
            return;
        }
        if (!this.isSorted) {
            Utils.sortSwagger(this.swagger);
            this.isSorted = true;
        }
        if ((dir = new File(this.swaggerPath)).isFile()) {
            throw new GenerateException(String.format("Swagger-outputDirectory[%s] must be a directory!", this.swaggerPath));
        }
        if (!dir.exists()) {
            try {
                FileUtils.forceMkdir((File)dir);
            }
            catch (IOException e) {
                throw new GenerateException(String.format("Create Swagger-outputDirectory[%s] failed.", this.swaggerPath));
            }
        }
        this.cleanupOlds(dir);
        File swaggerFile = new File(dir, "swagger.json");
        try {
            ObjectWriter jsonWriter = this.mapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
            jsonWriter.writeValue(swaggerFile, (Object)this.swagger);
        }
        catch (IOException e) {
            throw new GenerateException(e);
        }
    }

    public void loadOverridingModels() throws GenerateException {
        if (this.modelSubstitute != null) {
            ModelSubstitute modelSubstitute = new ModelSubstitute(new ObjectMapper());
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(this.modelSubstitute)));
            String line = null;
            try {
                line = reader.readLine();
                while (line != null) {
                    String[] classes = line.split(":");
                    if (classes == null || classes.length != 2) {
                        throw new GenerateException("Bad format of override model file, it should be ${actualClassName}:${expectClassName}");
                    }
                    modelSubstitute.substitute(classes[0].trim(), classes[1].trim());
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                throw new GenerateException(e);
            }
            ModelConverters.getInstance().addConverter((ModelConverter)modelSubstitute);
        }
    }

    private void cleanupOlds(File dir) {
        if (dir.listFiles() != null) {
            for (File f : dir.listFiles()) {
                if (!f.getName().endsWith("json")) continue;
                f.delete();
            }
        }
    }

    private void writeInDirectory(File dir, Swagger swaggerDoc, String basePath) throws GenerateException {
    }

    protected File createFile(File dir, String outputResourcePath) throws IOException {
        File serviceFile;
        int i = outputResourcePath.lastIndexOf("/");
        if (i != -1) {
            String fileName = outputResourcePath.substring(i + 1);
            String subDir = outputResourcePath.substring(0, i);
            File finalDirectory = new File(dir, subDir);
            finalDirectory.mkdirs();
            serviceFile = new File(finalDirectory, fileName);
        } else {
            serviceFile = new File(dir, outputResourcePath);
        }
        while (!serviceFile.createNewFile()) {
            serviceFile.delete();
        }
        this.LOG.info("Creating file " + serviceFile.getAbsolutePath());
        return serviceFile;
    }

    public void toDocuments() throws GenerateException {
        FileOutputStream fileOutputStream;
        if (!this.isSorted) {
            Utils.sortSwagger(this.swagger);
            this.isSorted = true;
        }
        this.LOG.info("Writing doc to " + this.outputPath + "...");
        try {
            fileOutputStream = new FileOutputStream(this.outputPath);
        }
        catch (FileNotFoundException e) {
            throw new GenerateException(e);
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));
        try {
            TemplatePath tp = Utils.parseTemplateUrl(this.templatePath);
            Handlebars handlebars = new Handlebars(tp.loader);
            this.initHandlebars(handlebars);
            Template template = handlebars.compile(tp.name);
            template.apply((Object)this.swagger, (Writer)writer);
            writer.close();
            this.LOG.info("Done!");
        }
        catch (MalformedURLException e) {
            throw new GenerateException(e);
        }
        catch (IOException e) {
            throw new GenerateException(e);
        }
    }

    private void initHandlebars(Handlebars handlebars) {
        handlebars.registerHelper("ifeq", (Helper)new Helper<String>(){

            public CharSequence apply(String value, Options options) throws IOException {
                if (value == null || options.param(0) == null) {
                    return options.inverse();
                }
                if (value.equals(options.param(0))) {
                    return options.fn();
                }
                return options.inverse();
            }
        });
        handlebars.registerHelper("basename", (Helper)new Helper<String>(){

            public CharSequence apply(String value, Options options) throws IOException {
                if (value == null) {
                    return null;
                }
                int lastSlash = value.lastIndexOf("/");
                if (lastSlash == -1) {
                    return value;
                }
                return value.substring(lastSlash + 1);
            }
        });
        handlebars.registerHelper(StringHelpers.join.name(), (Helper)StringHelpers.join);
        handlebars.registerHelper(StringHelpers.lower.name(), (Helper)StringHelpers.lower);
    }

    private String getUrlParent(URL url) {
        if (url == null) {
            return null;
        }
        String strurl = url.toString();
        int idx = strurl.lastIndexOf(47);
        if (idx == -1) {
            return strurl;
        }
        return strurl.substring(0, idx);
    }
}

