/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency.puml;

import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.puml.PumlNodeInfo;
import com.github.ferstl.depgraph.graph.NodeRenderer;
import com.google.common.base.Joiner;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;

public class PumlDependencyNodeNameRenderer
implements NodeRenderer<DependencyNode> {
    private static final Joiner NEWLINE_JOINER = Joiner.on((String)"\\n").skipNulls();
    private static final Joiner SLASH_JOINER = Joiner.on((String)"/").skipNulls();
    private final boolean showGroupId;
    private final boolean showArtifactId;
    private final boolean showTypes;
    private final boolean showClassifiers;
    private final boolean showVersion;
    private final boolean showOptional;
    private final boolean showScope;

    public PumlDependencyNodeNameRenderer(boolean showGroupId, boolean showArtifactId, boolean showTypes, boolean showClassifiers, boolean showVersion, boolean showOptional, boolean showScope) {
        this.showGroupId = showGroupId;
        this.showArtifactId = showArtifactId;
        this.showTypes = showTypes;
        this.showClassifiers = showClassifiers;
        this.showVersion = showVersion;
        this.showOptional = showOptional;
        this.showScope = showScope;
    }

    @Override
    public String render(DependencyNode node) {
        Artifact artifact = node.getArtifact();
        PumlNodeInfo nodeInfo = new PumlNodeInfo().withComponent("rectangle");
        String name = NEWLINE_JOINER.join((Object)(this.showGroupId ? artifact.getGroupId() : null), (Object)(this.showArtifactId ? artifact.getArtifactId() : null), new Object[]{this.showTypes ? PumlDependencyNodeNameRenderer.createTypeString(node.getTypes()) : null, this.showClassifiers ? PumlDependencyNodeNameRenderer.createClassifierString(node.getClassifiers()) : null, this.showVersion ? node.getEffectiveVersion() : null});
        if (this.showScope) {
            nodeInfo.withStereotype(node.getEffectiveScope());
        }
        nodeInfo.withLabel(name).withOptional(this.showOptional && artifact.isOptional());
        return nodeInfo.toString();
    }

    private static String createTypeString(Set<String> types) {
        if (types.size() > 1 || !types.contains("jar")) {
            LinkedHashSet<String> typesToDisplay = new LinkedHashSet<String>(types.size());
            for (String type : types) {
                typesToDisplay.add("." + type);
            }
            return SLASH_JOINER.join(typesToDisplay);
        }
        return "";
    }

    private static String createClassifierString(Set<String> classifiers) {
        return SLASH_JOINER.join(classifiers);
    }
}

