/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.NodeResolution;
import com.github.ferstl.depgraph.graph.EdgeRenderer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class JsonDependencyEdgeRenderer
implements EdgeRenderer<DependencyNode> {
    private final boolean renderVersions;
    private final ObjectMapper objectMapper;

    public JsonDependencyEdgeRenderer(boolean renderVersions) {
        this.renderVersions = renderVersions;
        this.objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }

    @Override
    public String render(DependencyNode from, DependencyNode to) {
        NodeResolution resolution = to.getResolution();
        boolean showVersion = resolution == NodeResolution.OMITTED_FOR_CONFLICT && this.renderVersions;
        DependencyData dependencyData = new DependencyData(showVersion ? to.getArtifact().getVersion() : null, resolution);
        StringWriter jsonStringWriter = new StringWriter();
        try {
            this.objectMapper.writer().writeValue((Writer)jsonStringWriter, (Object)dependencyData);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return jsonStringWriter.toString();
    }

    private static class DependencyData {
        private final String version;
        private final NodeResolution resolution;

        DependencyData(String version, NodeResolution resolution) {
            this.version = version;
            this.resolution = resolution;
        }
    }
}

