/*
 * Decompiled with CFR 0.152.
 */
package com.linuxense.javadbf;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFFieldNotFoundException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

public class DBFRow {
    private Object[] data;
    private Map<String, Integer> mapcolumnNames;
    private DBFField[] fields;

    protected DBFRow(Object[] data, Map<String, Integer> mapcolumnNames, DBFField[] fields) {
        this.data = data;
        this.mapcolumnNames = mapcolumnNames;
        this.fields = fields;
    }

    private int getColumnIndex(String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException("You must provide a columnName");
        }
        String key = columnName.toLowerCase();
        Integer index = this.mapcolumnNames.get(key);
        if (index == null) {
            throw new DBFFieldNotFoundException("No field found for:" + columnName);
        }
        return index;
    }

    public boolean isDeleted() {
        return "deleted".equals(this.fields[0].getName()) && this.getBoolean("deleted");
    }

    public Object getObject(String columnName) {
        return this.getObject(this.getColumnIndex(columnName));
    }

    public Object getObject(int columnIndex) {
        return this.data[columnIndex];
    }

    public String getString(String columnName) {
        return this.getString(this.getColumnIndex(columnName));
    }

    public String getString(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.data.length) {
            throw new IllegalArgumentException("Invalid index field: (" + columnIndex + "). Valid range is 0 to " + (this.data.length - 1));
        }
        Object fieldValue = this.data[columnIndex];
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof String) {
            return (String)fieldValue;
        }
        return fieldValue.toString();
    }

    public BigDecimal getBigDecimal(String columnName) {
        return this.getBigDecimal(this.getColumnIndex(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex) {
        Object fieldValue = this.data[columnIndex];
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof BigDecimal) {
            return (BigDecimal)fieldValue;
        }
        throw new DBFException("Unsupported type for BigDecimal at column:" + columnIndex + " " + fieldValue.getClass().getCanonicalName());
    }

    public boolean getBoolean(String columnName) {
        return this.getBoolean(this.getColumnIndex(columnName));
    }

    public boolean getBoolean(int columnIndex) {
        Object fieldValue = this.data[columnIndex];
        if (fieldValue == null) {
            return Boolean.FALSE;
        }
        if (fieldValue instanceof Boolean) {
            return (Boolean)fieldValue;
        }
        throw new DBFException("Unsupported type for Boolean at column:" + columnIndex + " " + fieldValue.getClass().getCanonicalName());
    }

    public byte[] getBytes(String columnName) {
        return this.getBytes(this.getColumnIndex(columnName));
    }

    public byte[] getBytes(int columnIndex) {
        Object fieldValue = this.data[columnIndex];
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof byte[]) {
            return (byte[])fieldValue;
        }
        throw new DBFException("Unsupported type for byte[] at column:" + columnIndex + " " + fieldValue.getClass().getCanonicalName());
    }

    public Date getDate(String columnName) {
        return this.getDate(this.getColumnIndex(columnName));
    }

    public Date getDate(int columnIndex) {
        Object fieldValue = this.data[columnIndex];
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof Date) {
            return (Date)fieldValue;
        }
        throw new DBFException("Unsupported type for Date at column:" + columnIndex + " " + fieldValue.getClass().getCanonicalName());
    }

    public double getDouble(String columnName) {
        return this.getDouble(this.getColumnIndex(columnName));
    }

    public double getDouble(int columnIndex) {
        Object fieldValue = this.data[columnIndex];
        if (fieldValue == null) {
            return 0.0;
        }
        if (fieldValue instanceof Number) {
            return ((Number)fieldValue).doubleValue();
        }
        throw new DBFException("Unsupported type for Number at column:" + columnIndex + " " + fieldValue.getClass().getCanonicalName());
    }

    public float getFloat(String columnName) {
        return this.getFloat(this.getColumnIndex(columnName));
    }

    public float getFloat(int columnIndex) {
        Object fieldValue = this.data[columnIndex];
        if (fieldValue == null) {
            return 0.0f;
        }
        if (fieldValue instanceof Number) {
            return ((Number)fieldValue).floatValue();
        }
        throw new DBFException("Unsupported type for Number at column:" + columnIndex + " " + fieldValue.getClass().getCanonicalName());
    }

    public int getInt(String columnName) {
        return this.getInt(this.getColumnIndex(columnName));
    }

    public int getInt(int columnIndex) {
        Object fieldValue = this.data[columnIndex];
        if (fieldValue == null) {
            return 0;
        }
        if (fieldValue instanceof Number) {
            return ((Number)fieldValue).intValue();
        }
        throw new DBFException("Unsupported type for Number at column:" + columnIndex + " " + fieldValue.getClass().getCanonicalName());
    }

    public long getLong(String columnName) {
        return this.getLong(this.getColumnIndex(columnName));
    }

    public long getLong(int columnIndex) {
        Object fieldValue = this.data[columnIndex];
        if (fieldValue == null) {
            return 0L;
        }
        if (fieldValue instanceof Number) {
            return ((Number)fieldValue).longValue();
        }
        throw new DBFException("Unsupported type for Number at column:" + columnIndex + " " + fieldValue.getClass().getCanonicalName());
    }
}

