/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.web;

import com.franciaflex.faxtomail.web.FaxToMailExecuteAndWaitInterceptor;
import com.franciaflex.faxtomail.web.HasUploadedFile;
import com.opensymphony.xwork2.ActionInvocation;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.struts2.interceptor.BackgroundProcess;
import org.apache.struts2.interceptor.ExecuteAndWaitInterceptor;

public class FaxToMailExecuteAndWaitInterceptor
extends ExecuteAndWaitInterceptor {
    protected BackgroundProcess getNewBackgroundProcess(String name, ActionInvocation actionInvocation, int threadPriority) {
        BackgroundProcess bgProcess;
        if (actionInvocation.getAction() instanceof HasUploadedFile) {
            HasUploadedFile uploadAction = (HasUploadedFile)actionInvocation.getAction();
            try {
                File origFile = uploadAction.getUploadedFile();
                if (origFile != null) {
                    File altFile = new File(origFile.getParentFile(), origFile.getName() + "-alt.tmp");
                    FileUtils.copyFile((File)origFile, (File)altFile);
                    altFile.deleteOnExit();
                    uploadAction.setUploadedFile(altFile);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Error copying uploaded file", ex);
            }
            bgProcess = new UploadBackgroundProcess(this, name + "BackgroundThread", actionInvocation, threadPriority);
        } else {
            bgProcess = super.getNewBackgroundProcess(name, actionInvocation, threadPriority);
        }
        return bgProcess;
    }
}

