/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.web.action.admin;

import com.franciaflex.faxtomail.persistence.entities.Configuration;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.EmailAccount;
import com.franciaflex.faxtomail.persistence.entities.EmailProtocol;
import com.franciaflex.faxtomail.persistence.entities.EtatAttente;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup;
import com.franciaflex.faxtomail.persistence.entities.FolderAction;
import com.franciaflex.faxtomail.persistence.entities.MailAction;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.persistence.entities.MailFilter;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.services.service.ConfigurationService;
import com.franciaflex.faxtomail.services.service.MailFolderService;
import com.franciaflex.faxtomail.services.service.ReferentielService;
import com.franciaflex.faxtomail.web.FaxToMailActionSupport;
import com.opensymphony.xwork2.Preparable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.apache.struts2.convention.annotation.Result;

@InterceptorRefs(value={@InterceptorRef(value="loginInterceptor"), @InterceptorRef(value="faxToMailStack")})
public class ConfigurationAction
extends FaxToMailActionSupport
implements Preparable {
    private static final Log log = LogFactory.getLog(ConfigurationAction.class);
    protected ConfigurationService configurationService;
    protected ReferentielService referentielService;
    protected MailFolderService mailFolderService;
    protected Configuration configuration;
    protected List<EtatAttente> etatAttentes;
    protected Map<String, Long> etatAttentesUsage;
    protected List<DemandType> demandTypes;
    protected List<MailFolder> mailFolders;
    protected Map<String, Long> mailFoldersUsage;
    protected List<MailFilter> mailFilters;
    protected List<EmailAccount> emailAccounts;
    protected List<FaxToMailUser> users;
    protected List<FaxToMailUserGroup> groups;

    public void prepare() throws Exception {
    }

    @Action(value="configuration-input")
    public String input() throws Exception {
        this.etatAttentes = this.referentielService.getAllEtatAttente();
        this.etatAttentesUsage = this.referentielService.getEtatAttentesUsage();
        this.demandTypes = this.referentielService.getAllDemandType();
        this.mailFolders = this.mailFolderService.getRootMailFolders();
        this.mailFoldersUsage = this.mailFolderService.getMailFoldersUsage();
        this.emailAccounts = this.configurationService.getEmailAccountsWithoutPasswords();
        this.mailFilters = this.configurationService.getMailFilters();
        this.configuration = this.configurationService.getConfiguration();
        this.users = this.configurationService.getAllUsers();
        this.groups = this.configurationService.getAllGroups();
        return "input";
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "configuration-input"})})
    public String execute() throws Exception {
        String result = super.execute();
        this.configurationService.saveConfiguration(this.configuration);
        this.referentielService.saveEtatAttente((Collection)this.etatAttentes);
        this.referentielService.saveDemandTypes(this.demandTypes);
        this.mailFolderService.saveMailFolders((Collection)this.mailFolders);
        this.configurationService.saveMailFilters(this.mailFilters);
        this.configurationService.saveEmailAccounts(this.emailAccounts);
        return result;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    public void setMailFolderService(MailFolderService mailFolderService) {
        this.mailFolderService = mailFolderService;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfigurationJson(String json) {
        this.configuration = (Configuration)this.getGson().fromJson(json, Configuration.class);
    }

    public List<EtatAttente> getEtatAttentes() {
        return this.etatAttentes;
    }

    public void setEtatAttentesJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.etatAttentes = (List)this.getGson().fromJson(json, type);
    }

    public Map<String, Long> getEtatAttentesUsage() {
        return this.etatAttentesUsage;
    }

    public List<DemandType> getDemandTypes() {
        return this.demandTypes;
    }

    public void setDemandTypesJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.demandTypes = (List)this.getGson().fromJson(json, type);
    }

    public List<MailFolder> getMailFolders() {
        return this.mailFolders;
    }

    public void setMailFoldersJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.mailFolders = (List)this.getGson().fromJson(json, type);
    }

    public List<MailFilter> getMailFilters() {
        return this.mailFilters;
    }

    public void setMailFiltersJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.mailFilters = (List)this.getGson().fromJson(json, type);
    }

    public Map<String, Long> getMailFoldersUsage() {
        return this.mailFoldersUsage;
    }

    public List<EmailAccount> getEmailAccounts() {
        return this.emailAccounts;
    }

    public void setEmailAccountsJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.emailAccounts = (List)this.getGson().fromJson(json, type);
    }

    public List<FaxToMailUser> getUsers() {
        return this.users;
    }

    public List<FaxToMailUserGroup> getGroups() {
        return this.groups;
    }

    public Map<MailAction, String> getMailActions() {
        return this.getEnumAsMap((Object[])MailAction.values());
    }

    public Map<FolderAction, String> getFolderActions() {
        return this.getEnumAsMap((Object[])FolderAction.values());
    }

    public Map<MailField, String> getMailFields() {
        return this.getEnumAsMap((Object[])MailField.values());
    }

    public Map<EmailProtocol, Integer> getEmailProtocolPorts() {
        LinkedHashMap<EmailProtocol, Integer> result = new LinkedHashMap<EmailProtocol, Integer>();
        for (EmailProtocol protocol : EmailProtocol.values()) {
            result.put(protocol, protocol.getDefaultPort());
        }
        return result;
    }
}

