/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.io.IOException;
import java.util.Arrays;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;

public final class PDColor {
    private final float[] components;
    private final COSName patternName;
    private final PDColorSpace colorSpace;

    public PDColor(COSArray array, PDColorSpace colorSpace) {
        if (array.size() > 0 && array.get(array.size() - 1) instanceof COSName) {
            this.components = new float[array.size() - 1];
            for (int i = 0; i < array.size() - 1; ++i) {
                this.components[i] = ((COSNumber)array.get(i)).floatValue();
            }
            this.patternName = (COSName)array.get(array.size() - 1);
        } else {
            this.components = new float[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                this.components[i] = ((COSNumber)array.get(i)).floatValue();
            }
            this.patternName = null;
        }
        this.colorSpace = colorSpace;
    }

    public PDColor(float[] components, PDColorSpace colorSpace) {
        this.components = (float[])components.clone();
        this.patternName = null;
        this.colorSpace = colorSpace;
    }

    public PDColor(COSName patternName, PDColorSpace colorSpace) {
        this.components = new float[0];
        this.patternName = patternName;
        this.colorSpace = colorSpace;
    }

    public PDColor(float[] components, COSName patternName, PDColorSpace colorSpace) {
        this.components = (float[])components.clone();
        this.patternName = patternName;
        this.colorSpace = colorSpace;
    }

    public float[] getComponents() {
        return (float[])this.components.clone();
    }

    public COSName getPatternName() {
        return this.patternName;
    }

    public boolean isPattern() {
        return this.patternName != null;
    }

    public int toRGB() throws IOException {
        float[] floats = this.colorSpace.toRGB(this.components);
        int r = Math.round(floats[0] * 255.0f);
        int g = Math.round(floats[1] * 255.0f);
        int b = Math.round(floats[2] * 255.0f);
        int rgb = r;
        rgb = (rgb << 8) + g;
        rgb = (rgb << 8) + b;
        return rgb;
    }

    public COSArray toCOSArray() {
        COSArray array = new COSArray();
        array.setFloatArray(this.components);
        array.add(this.patternName);
        return array;
    }

    public PDColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public String toString() {
        return "PDColor{components=" + Arrays.toString(this.components) + ", patternName=" + this.patternName + "}";
    }
}

