/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import javax.swing.Action;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.DefaultTokenFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenFactory;
import org.fife.ui.rsyntaxtextarea.TokenMaker;
import org.fife.ui.rsyntaxtextarea.VisibleWhitespaceTokenFactory;

abstract class TokenMakerBase
implements TokenMaker {
    protected Token firstToken = null;
    protected Token currentToken = null;
    protected Token previousToken = null;
    private TokenFactory tokenFactory = new DefaultTokenFactory();

    public void addNullToken() {
        if (this.firstToken == null) {
            this.currentToken = this.firstToken = this.tokenFactory.createToken();
        } else {
            this.currentToken.setNextToken(this.tokenFactory.createToken());
            this.previousToken = this.currentToken;
            this.currentToken = this.currentToken.getNextToken();
        }
    }

    public void addToken(Segment segment, int start, int end, int tokenType, int startOffset) {
        this.addToken(segment.array, start, end, tokenType, startOffset);
    }

    public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
        this.addToken(array, start, end, tokenType, startOffset, false);
    }

    public void addToken(char[] array, int start, int end, int tokenType, int startOffset, boolean hyperlink) {
        if (this.firstToken == null) {
            this.currentToken = this.firstToken = this.tokenFactory.createToken(array, start, end, startOffset, tokenType);
        } else {
            this.currentToken.setNextToken(this.tokenFactory.createToken(array, start, end, startOffset, tokenType));
            this.previousToken = this.currentToken;
            this.currentToken = this.currentToken.getNextToken();
        }
        this.currentToken.setHyperlink(hyperlink);
    }

    public boolean getCurlyBracesDenoteCodeBlocks() {
        return false;
    }

    public Action getInsertBreakAction() {
        return null;
    }

    public int getLastTokenTypeOnLine(Segment text, int initialTokenType) {
        Token t = this.getTokenList(text, initialTokenType, 0);
        while (t.getNextToken() != null) {
            t = t.getNextToken();
        }
        return t.type;
    }

    public String[] getLineCommentStartAndEnd() {
        return null;
    }

    public boolean getMarkOccurrencesOfTokenType(int type) {
        return type == 15;
    }

    public boolean getShouldIndentNextLineAfter(Token token) {
        return false;
    }

    public boolean isMarkupLanguage() {
        return false;
    }

    protected void resetTokenList() {
        this.previousToken = null;
        this.currentToken = null;
        this.firstToken = null;
        this.tokenFactory.resetAllTokens();
    }

    public void setWhitespaceVisible(boolean visible, RSyntaxTextArea textArea) {
        this.tokenFactory = visible ? new VisibleWhitespaceTokenFactory() : new DefaultTokenFactory();
    }
}

