/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.perl;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ac.c.CCompletionProvider;
import org.fife.rsta.ac.perl.PerlCodeCompletionProvider;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.autocomplete.VariableCompletion;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;

public class PerlCompletionProvider
extends CCompletionProvider {
    private boolean useParensWithFunctions;
    private CaseInsensitiveComparator comparator = new CaseInsensitiveComparator();

    protected void addShorthandCompletions(DefaultCompletionProvider codeCP) {
    }

    protected CompletionProvider createCodeCompletionProvider() {
        PerlCodeCompletionProvider cp = new PerlCodeCompletionProvider(this);
        this.loadCodeCompletionsFromXml(cp);
        this.addShorthandCompletions(cp);
        return cp;
    }

    protected CompletionProvider createStringCompletionProvider() {
        DefaultCompletionProvider cp = new DefaultCompletionProvider();
        return cp;
    }

    protected List getCompletionsImpl(JTextComponent comp) {
        List completions = super.getCompletionsImpl(comp);
        SortedSet varCompletions = this.getVariableCompletions(comp);
        if (varCompletions != null) {
            completions.addAll(varCompletions);
            Collections.sort(completions);
        }
        return completions;
    }

    public char getParameterListEnd() {
        return this.getUseParensWithFunctions() ? (char)')' : '\u0000';
    }

    public char getParameterListStart() {
        return this.getUseParensWithFunctions() ? (char)'(' : ' ';
    }

    public boolean getUseParensWithFunctions() {
        return this.useParensWithFunctions;
    }

    private SortedSet getVariableCompletions(JTextComponent comp) {
        char firstChar;
        RSyntaxTextArea textArea = (RSyntaxTextArea)comp;
        int dot = textArea.getCaretPosition();
        int lastLine = 0;
        try {
            lastLine = textArea.getLineOfOffset(dot);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return null;
        }
        RSyntaxDocument doc = (RSyntaxDocument)comp.getDocument();
        SortedSet<String> varCompletions = null;
        String text = this.getDefaultCompletionProvider().getAlreadyEnteredText(comp);
        char c = firstChar = text.length() == 0 ? (char)'\u0000' : text.charAt(0);
        if (firstChar != '$' && firstChar != '@' && firstChar != '%') {
            System.out.println("DEBUG: No use matching variables, exiting");
            return null;
        }
        for (int i = 0; i <= lastLine; ++i) {
            for (Token t = doc.getTokenListForLine(i); t != null && t.offset + t.textCount < dot && t.isPaintable(); t = t.getNextToken()) {
                String name;
                char ch;
                if (t.type != 14 || firstChar > (ch = (name = t.getLexeme()).charAt(0))) continue;
                if (varCompletions == null) {
                    varCompletions = new TreeSet<String>(this.comparator);
                }
                if (firstChar < ch) {
                    name = firstChar + name.substring(1);
                }
                VariableCompletion vc = new VariableCompletion((CompletionProvider)this, name, null);
                varCompletions.add((String)vc);
            }
        }
        if (varCompletions != null) {
            varCompletions = varCompletions.subSet(text, text + '{');
        }
        return varCompletions;
    }

    protected String getXmlResource() {
        return "data/perl5.xml";
    }

    public void setUseParensWithFunctions(boolean use) {
        this.useParensWithFunctions = use;
    }

    private static class CaseInsensitiveComparator
    implements Comparator,
    Serializable {
        private CaseInsensitiveComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = o1 instanceof String ? (String)o1 : ((Completion)o1).getInputText();
            String s2 = o2 instanceof String ? (String)o2 : ((Completion)o2).getInputText();
            return String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
        }
    }
}

