/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ac.java.IconFactory;
import org.fife.rsta.ac.java.MemberCompletion;
import org.fife.rsta.ac.java.MethodData;
import org.fife.rsta.ac.java.MethodInfoData;
import org.fife.rsta.ac.java.SourceCompletionProvider;
import org.fife.rsta.ac.java.Util;
import org.fife.rsta.ac.java.classreader.MethodInfo;
import org.fife.rsta.ac.java.rjc.ast.FormalParameter;
import org.fife.rsta.ac.java.rjc.ast.Method;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.FunctionCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletion;

class MethodCompletion
extends FunctionCompletion
implements MemberCompletion {
    private MemberCompletion.Data data;

    public MethodCompletion(CompletionProvider provider, Method m, String typeName) {
        super(provider, m.getName(), m.getType() == null ? "void" : m.getType().toString());
        this.setDefinedIn(typeName);
        this.data = new MethodData(m);
        int count = m.getParameterCount();
        ArrayList<ParameterizedCompletion.Parameter> params = new ArrayList<ParameterizedCompletion.Parameter>(count);
        for (int i = 0; i < count; ++i) {
            FormalParameter param = m.getParameter(i);
            String type = param.getType().toString();
            String name = param.getName();
            params.add(new ParameterizedCompletion.Parameter(type, name));
        }
        this.setParams(params);
    }

    public MethodCompletion(CompletionProvider provider, MethodInfo info, String typeName) {
        super(provider, info.getName(), info.getReturnTypeString());
        this.setDefinedIn(typeName);
        this.data = new MethodInfoData(info, (SourceCompletionProvider)provider);
        String[] paramTypes = info.getParameterTypes();
        ArrayList<ParameterizedCompletion.Parameter> params = new ArrayList<ParameterizedCompletion.Parameter>(paramTypes.length);
        for (int i = 0; i < paramTypes.length; ++i) {
            String name = paramTypes[i].substring(paramTypes[i].lastIndexOf(46) + 1);
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            params.add(new ParameterizedCompletion.Parameter(paramTypes[i], name));
        }
        this.setParams(params);
    }

    public boolean equals(Object obj) {
        return obj instanceof MethodCompletion && ((MethodCompletion)obj).getSignature().equals(this.getSignature());
    }

    public String getAlreadyEntered(JTextComponent comp) {
        String temp = this.getProvider().getAlreadyEnteredText(comp);
        int lastDot = temp.lastIndexOf(46);
        if (lastDot > -1) {
            temp = temp.substring(lastDot + 1);
        }
        return temp;
    }

    public Icon getIcon() {
        return IconFactory.get().getIcon(this.data);
    }

    public String getSignature() {
        return this.data.getSignature();
    }

    public String getSummary() {
        String summary = this.data.getSummary();
        if (summary != null && summary.startsWith("/**")) {
            summary = Util.docCommentToHtml(summary);
        }
        return summary;
    }

    public int hashCode() {
        return this.getSignature().hashCode();
    }

    public boolean isDeprecated() {
        return this.data.isDeprecated();
    }

    public void rendererText(Graphics g, int x, int y, boolean selected) {
        MethodCompletion.rendererText(this, g, x, y, selected);
    }

    public String toString() {
        return this.getSignature();
    }

    public static void rendererText(MemberCompletion mc, Graphics g, int x, int y, boolean selected) {
        String shortType = mc.getType();
        int dot = shortType.lastIndexOf(46);
        if (dot > -1) {
            shortType = shortType.substring(dot + 1);
        }
        String sig = mc.getSignature();
        FontMetrics fm = g.getFontMetrics();
        g.drawString(sig, x, y);
        int newX = x + fm.stringWidth(sig);
        if (mc.isDeprecated()) {
            int midY = y + fm.getDescent() - fm.getHeight() / 2;
            g.drawLine(x, midY, newX, midY);
        }
        x = newX;
        StringBuffer sb = new StringBuffer(" : ").append(shortType);
        sb.append(" - ");
        String s = sb.toString();
        g.drawString(s, x, y);
        x += fm.stringWidth(s);
        Color origColor = g.getColor();
        if (!selected) {
            g.setColor(Color.GRAY);
        }
        g.drawString(Util.getUnqualified(mc.getDefinedIn()), x, y);
        if (!selected) {
            g.setColor(origColor);
        }
    }
}

