/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.fife.rsta.ac.java.JavaSourceCompletion;
import org.fife.ui.autocomplete.BasicCompletion;

public class JavaCellRenderer
extends DefaultListCellRenderer {
    private JList list;
    private boolean selected;
    private boolean evenRow;
    private JavaSourceCompletion jsc;
    private static Color altBG;
    private BasicCompletion bc;

    public static Color getAlternateBackground() {
        return altBG;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, selected, hasFocus);
        this.setText("Foobar");
        this.list = list;
        this.selected = selected;
        if (value instanceof JavaSourceCompletion) {
            this.jsc = (JavaSourceCompletion)value;
            this.bc = null;
            this.setIcon(this.jsc.getIcon());
        } else {
            this.jsc = null;
            this.bc = (BasicCompletion)value;
            this.setIcon(null);
        }
        boolean bl = this.evenRow = (index & 1) == 0;
        if (altBG != null && this.evenRow && !selected) {
            this.setBackground(altBG);
        }
        return this;
    }

    protected void paintComponent(Graphics g) {
        int x;
        Graphics2D g2d = (Graphics2D)g;
        Object old = null;
        Map hints = (Map)this.getToolkit().getDesktopProperty("awt.font.desktophints");
        if (hints != null) {
            old = g2d.getRenderingHints();
            g2d.addRenderingHints(hints);
        } else {
            old = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int iconW = 18;
        int h = this.getHeight();
        if (!this.selected) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), h);
        } else {
            g.setColor(altBG != null && this.evenRow ? altBG : this.list.getBackground());
            g.fillRect(0, 0, 18, h);
            g.setColor(this.getBackground());
            g.fillRect(18, 0, this.getWidth() - 18, h);
        }
        if (this.getIcon() != null) {
            int y = (h - this.getIcon().getIconHeight()) / 2;
            this.getIcon().paintIcon(this, g, 0, y);
        }
        if (this.jsc != null) {
            x = this.getX() + 18 + 2;
            g.setColor(this.selected ? this.list.getSelectionForeground() : this.list.getForeground());
            this.jsc.rendererText(g, x, g.getFontMetrics().getHeight(), this.selected);
        } else if (this.bc != null) {
            x = this.getX() + 18 + 2;
            g.setColor(this.selected ? this.list.getSelectionForeground() : this.list.getForeground());
            g.drawString(this.bc.toString(), x, g.getFontMetrics().getHeight());
        }
        if (hints != null) {
            g2d.addRenderingHints((Map)old);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, old);
        }
    }

    public static void setAlternateBackground(Color altBG) {
        JavaCellRenderer.altBG = altBG;
    }
}

