/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.index;

import com.browseengine.bobo.index.BoboIndexer;
import com.browseengine.bobo.index.digest.FileDigester;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class MakeBobo {
    private static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("BoboIndexer", options);
    }

    public static void main(String[] args) throws IOException {
        Option help = new Option("help", false, "print this message");
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"data source - required");
        Option src = OptionBuilder.create((String)"source");
        src.setRequired(true);
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"index to create - required");
        Option index = OptionBuilder.create((String)"index");
        index.setRequired(true);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"field configuration - optional");
        Option conf = OptionBuilder.create((String)"conf");
        OptionBuilder.withArgName((String)"class");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"class name of the data digester - default: xml digester");
        Option digesterOpt = OptionBuilder.create((String)"digester");
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"character set name - default: UTF-8");
        Option charset = OptionBuilder.create((String)"charset");
        OptionBuilder.withArgName((String)"maxdocs");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"maximum number of documents - default: 100");
        Option maxdocs = OptionBuilder.create((String)"maxdocs");
        Options options = new Options();
        options.addOption(help);
        options.addOption(conf);
        options.addOption(index);
        options.addOption(src);
        options.addOption(charset);
        options.addOption(digesterOpt);
        options.addOption(maxdocs);
        BasicParser parser = new BasicParser();
        try {
            FileDigester digester;
            int maxDocs;
            CommandLine line = parser.parse(options, args);
            String output = line.getOptionValue("index");
            File data = new File(line.getOptionValue("source"));
            if (!line.hasOption("digester")) {
                throw new RuntimeException("digester not specified");
            }
            Class<?> digesterClass = Class.forName(line.getOptionValue("digester"));
            Charset chset = line.hasOption("charset") ? Charset.forName(line.getOptionValue("charset")) : Charset.forName("UTF-8");
            try {
                maxDocs = Integer.parseInt(line.getOptionValue("maxdocs"));
            }
            catch (Exception e) {
                maxDocs = 100;
            }
            try {
                Constructor<?> constructor = digesterClass.getConstructor(File.class);
                digester = (FileDigester)constructor.newInstance(data);
                digester.setCharset(chset);
                digester.setMaxDocs(maxDocs);
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid digester class.", e);
            }
            BoboIndexer indexer = new BoboIndexer(digester, (Directory)FSDirectory.open((File)new File(output)));
            indexer.index();
        }
        catch (ParseException exp) {
            exp.printStackTrace();
            MakeBobo.usage(options);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Invalid digester class.");
            MakeBobo.usage(options);
        }
    }
}

