/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.FacetIterator;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.data.TermStringList;
import com.browseengine.bobo.facets.filter.GeoFacetFilter;
import com.browseengine.bobo.facets.impl.DefaultFacetIterator;
import com.browseengine.bobo.facets.impl.GeoFacetHandler;
import com.browseengine.bobo.util.BigFloatArray;
import com.browseengine.bobo.util.GeoMatchUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GeoFacetCountCollector
implements FacetCountCollector {
    private final String _name;
    private final FacetSpec _spec;
    private int[] _count;
    private int _countlength;
    private GeoFacetHandler.GeoFacetData _dataCache;
    private final TermStringList _predefinedRanges;
    private int _docBase;
    private GeoRange[] _ranges;
    private BigFloatArray _xvals;
    private BigFloatArray _yvals;
    private BigFloatArray _zvals;
    private boolean _miles;

    protected GeoFacetCountCollector(String name, GeoFacetHandler.GeoFacetData dataCache, int docBase, FacetSpec fspec, List<String> predefinedRanges, boolean miles) {
        this._name = name;
        this._dataCache = dataCache;
        this._xvals = dataCache.get_xValArray();
        this._yvals = dataCache.get_yValArray();
        this._zvals = dataCache.get_zValArray();
        this._spec = fspec;
        this._predefinedRanges = new TermStringList();
        Collections.sort(predefinedRanges);
        this._predefinedRanges.addAll((Collection<? extends String>)predefinedRanges);
        this._docBase = docBase;
        this._countlength = predefinedRanges.size();
        this._count = new int[this._countlength];
        this._ranges = new GeoRange[predefinedRanges.size()];
        int index = 0;
        for (String range : predefinedRanges) {
            this._ranges[index++] = GeoFacetCountCollector.parse(range);
        }
        this._miles = miles;
    }

    @Override
    public void collect(int docid) {
        float docX = this._xvals.get(docid);
        float docY = this._yvals.get(docid);
        float docZ = this._zvals.get(docid);
        int countIndex = -1;
        for (GeoRange range : this._ranges) {
            ++countIndex;
            float radius = this._miles ? GeoMatchUtil.getMilesRadiusCosine(range.getRad()) : GeoMatchUtil.getKMRadiusCosine(range.getRad());
            float[] coords = GeoMatchUtil.geoMatchCoordsFromDegrees(range.getLat(), range.getLon());
            float targetX = coords[0];
            float targetY = coords[1];
            float targetZ = coords[2];
            float delta = this._miles ? range.getRad() / 3956.0f : range.getRad() / 6371.0f;
            float xu = targetX + delta;
            float xl = targetX - delta;
            if (docX > xu || docX < xl) continue;
            float yu = targetY + delta;
            float yl = targetY - delta;
            if (docY > yu || docY < yl) continue;
            float zu = targetZ + delta;
            float zl = targetZ - delta;
            if (docZ > zu || docZ < zl || !GeoFacetFilter.inCircle(docX, docY, docZ, targetX, targetY, targetZ, radius)) continue;
            int n = countIndex;
            this._count[n] = this._count[n] + 1;
        }
    }

    @Override
    public void collectAll() {
        throw new UnsupportedOperationException("collectAll is not supported for Geo Facets yet");
    }

    @Override
    public int[] getCountDistribution() {
        int[] dist = null;
        if (this._predefinedRanges != null) {
            dist = new int[this._predefinedRanges.size()];
            int distIdx = 0;
            for (int count : this._count) {
                dist[distIdx++] = count;
            }
        }
        return dist;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public BrowseFacet getFacet(String value) {
        if (this._predefinedRanges != null) {
            int index = 0;
            index = this._predefinedRanges.indexOf(value);
            if (index != -1) {
                BrowseFacet choice = new BrowseFacet();
                choice.setHitCount(this._count[index]);
                choice.setValue(value);
                return choice;
            }
            throw new IllegalArgumentException("The value argument is not one of the user-specified ranges");
        }
        throw new IllegalArgumentException("There are no user-specified ranges for this Facet Count Collector object");
    }

    @Override
    public List<BrowseFacet> getFacets() {
        if (this._spec != null) {
            int minHitCount = this._spec.getMinHitCount();
            if (this._ranges != null) {
                ArrayList<BrowseFacet> facets = new ArrayList<BrowseFacet>();
                int countIndex = -1;
                for (String value : this._predefinedRanges) {
                    if (this._count[++countIndex] < minHitCount) continue;
                    BrowseFacet choice = new BrowseFacet();
                    choice.setHitCount(this._count[countIndex]);
                    choice.setValue(value);
                    facets.add(choice);
                }
                return facets;
            }
            return FacetCountCollector.EMPTY_FACET_LIST;
        }
        return FacetCountCollector.EMPTY_FACET_LIST;
    }

    public static GeoRange parse(String range) {
        String[] parts = range.split(":");
        if (parts == null || parts.length != 2) {
            throw new IllegalArgumentException("Range value not in the expected format(lat, lon : radius)");
        }
        String coord_part = parts[0];
        float rad = Float.parseFloat(parts[1].trim());
        String[] coords = coord_part.split(",");
        if (coords == null || coords.length != 2) {
            throw new IllegalArgumentException("Range value not in the expected format(lat, lon : radius)");
        }
        float lat = Float.parseFloat(coords[0].trim());
        float lon = Float.parseFloat(coords[1].trim());
        return new GeoRange(lat, lon, rad);
    }

    @Override
    public void close() {
    }

    @Override
    public FacetIterator iterator() {
        return new DefaultFacetIterator(this._predefinedRanges, this._count, this._countlength, true);
    }

    public static class GeoRange {
        private final float _lat;
        private final float _lon;
        private final float _rad;

        public GeoRange(float lat, float lon, float radius) {
            this._lat = lat;
            this._lon = lon;
            this._rad = radius;
        }

        public float getLat() {
            return this._lat;
        }

        public float getLon() {
            return this._lon;
        }

        public float getRad() {
            return this._rad;
        }
    }
}

