/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetAccessible;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.CombinedFacetAccessible;
import com.browseengine.bobo.facets.FacetCountCollectorSource;
import com.browseengine.bobo.facets.filter.EmptyFilter;
import com.browseengine.bobo.facets.filter.RandomAccessAndFilter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.filter.RandomAccessNotFilter;
import com.browseengine.bobo.facets.filter.RandomAccessOrFilter;
import com.browseengine.bobo.sort.DocComparatorSource;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class FacetHandler<D> {
    protected final String _name;
    private final Set<String> _dependsOn;
    private final Map<String, FacetHandler<?>> _dependedFacetHandlers;
    private TermCountSize _termCountSize;

    public FacetHandler(String name, Set<String> dependsOn) {
        this._name = name;
        this._dependsOn = new HashSet<String>();
        if (dependsOn != null) {
            this._dependsOn.addAll(dependsOn);
        }
        this._dependedFacetHandlers = new HashMap();
        this._termCountSize = TermCountSize.large;
    }

    public void setTermCountSize(String termCountSize) {
        this.setTermCountSize(TermCountSize.valueOf(termCountSize.toLowerCase()));
    }

    public void setTermCountSize(TermCountSize termCountSize) {
        this._termCountSize = termCountSize;
    }

    public TermCountSize getTermCountSize() {
        return this._termCountSize;
    }

    public FacetHandler(String name) {
        this(name, null);
    }

    public final String getName() {
        return this._name;
    }

    public final Set<String> getDependsOn() {
        return this._dependsOn;
    }

    public final void putDependedFacetHandler(FacetHandler<?> facetHandler) {
        this._dependedFacetHandlers.put(facetHandler._name, facetHandler);
    }

    public final FacetHandler<?> getDependedFacetHandler(String name) {
        return this._dependedFacetHandlers.get(name);
    }

    public abstract D load(BoboIndexReader var1) throws IOException;

    public FacetAccessible merge(FacetSpec fspec, List<FacetAccessible> facetList) {
        return new CombinedFacetAccessible(fspec, facetList);
    }

    public D getFacetData(BoboIndexReader reader) {
        return (D)reader.getFacetData(this._name);
    }

    public D load(BoboIndexReader reader, BoboIndexReader.WorkArea workArea) throws IOException {
        return this.load(reader);
    }

    public void loadFacetData(BoboIndexReader reader, BoboIndexReader.WorkArea workArea) throws IOException {
        reader.putFacetData(this._name, this.load(reader, workArea));
    }

    public void loadFacetData(BoboIndexReader reader) throws IOException {
        reader.putFacetData(this._name, this.load(reader));
    }

    public final RandomAccessFilter buildFilter(BrowseSelection sel) throws IOException {
        String[] selections = sel.getValues();
        String[] notSelections = sel.getNotValues();
        Properties prop = sel.getSelectionProperties();
        RandomAccessFilter filter = null;
        if (selections != null && selections.length > 0) {
            if (sel.getSelectionOperation() == BrowseSelection.ValueOperation.ValueOperationAnd) {
                filter = this.buildRandomAccessAndFilter(selections, prop);
                if (filter == null) {
                    filter = EmptyFilter.getInstance();
                }
            } else {
                filter = this.buildRandomAccessOrFilter(selections, prop, false);
                if (filter == null) {
                    return EmptyFilter.getInstance();
                }
            }
        }
        if (notSelections != null && notSelections.length > 0) {
            RandomAccessFilter notFilter = this.buildRandomAccessOrFilter(notSelections, prop, true);
            if (filter == null) {
                filter = notFilter;
            } else {
                RandomAccessAndFilter andFilter = new RandomAccessAndFilter(Arrays.asList(filter, notFilter));
                filter = andFilter;
            }
        }
        return filter;
    }

    public abstract RandomAccessFilter buildRandomAccessFilter(String var1, Properties var2) throws IOException;

    public RandomAccessFilter buildRandomAccessAndFilter(String[] vals, Properties prop) throws IOException {
        ArrayList<RandomAccessFilter> filterList = new ArrayList<RandomAccessFilter>(vals.length);
        for (String val : vals) {
            RandomAccessFilter f = this.buildRandomAccessFilter(val, prop);
            if (f == null) {
                return null;
            }
            filterList.add(f);
        }
        if (filterList.size() == 0) {
            return null;
        }
        return new RandomAccessAndFilter(filterList);
    }

    public RandomAccessFilter buildRandomAccessOrFilter(String[] vals, Properties prop, boolean isNot) throws IOException {
        ArrayList<RandomAccessFilter> filterList = new ArrayList<RandomAccessFilter>(vals.length);
        for (String val : vals) {
            RandomAccessFilter f = this.buildRandomAccessFilter(val, prop);
            if (f == null || f instanceof EmptyFilter) continue;
            filterList.add(f);
        }
        RandomAccessFilter finalFilter = filterList.size() == 0 ? EmptyFilter.getInstance() : new RandomAccessOrFilter(filterList);
        if (isNot) {
            finalFilter = new RandomAccessNotFilter(finalFilter);
        }
        return finalFilter;
    }

    public abstract FacetCountCollectorSource getFacetCountCollectorSource(BrowseSelection var1, FacetSpec var2);

    public FacetCountCollectorSource getFacetCountCollectorSource(BrowseSelection sel, FacetSpec ospec, boolean groupMode) {
        return this.getFacetCountCollectorSource(sel, ospec);
    }

    public abstract String[] getFieldValues(BoboIndexReader var1, int var2);

    public Object[] getRawFieldValues(BoboIndexReader reader, int id) {
        return this.getFieldValues(reader, id);
    }

    public String getFieldValue(BoboIndexReader reader, int id) {
        return this.getFieldValues(reader, id)[0];
    }

    public abstract DocComparatorSource getDocComparatorSource();

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static enum TermCountSize {
        small,
        medium,
        large;

    }

    public static class FacetDataNone
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static FacetDataNone instance = new FacetDataNone();

        private FacetDataNone() {
        }
    }
}

