/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.util;

import com.browseengine.bobo.util.SparseFloatArray;
import java.util.Hashtable;
import java.util.Map;

public class MutableSparseFloatArray
extends SparseFloatArray {
    private Map<Integer, Float> _map = new Hashtable<Integer, Float>();
    private boolean _isDirty = false;

    public MutableSparseFloatArray(float[] floats) {
        super(floats);
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    @Override
    public synchronized float get(int idx) {
        float val = super.get(idx);
        if (val != 0.0f) {
            return val;
        }
        Float stored = this._map.get(idx);
        if (stored != null) {
            return stored.floatValue();
        }
        return 0.0f;
    }

    public synchronized void set(int idx, float val) {
        this._isDirty = true;
        if (null == this._bits && null != this._floats) {
            this._floats[idx] = val;
        } else if (null != this._bits && this._bits.get(idx)) {
            int ref = idx / 32 - 1;
            int count = ref >= 0 ? this._referencePoints[ref] : 0;
            int i = idx - idx % 32;
            while ((i = this._bits.nextSetBit(i)) >= 0 && i < idx) {
                ++count;
                ++i;
            }
            this._floats[count] = val;
        } else {
            if (val != 0.0f) {
                this._map.put(idx, Float.valueOf(val));
            } else {
                Float stored = this._map.get(idx);
                if (stored != null) {
                    this._map.remove(idx);
                }
            }
            int sz = this._map.size();
            if (sz > 512 && (null == this._floats || (sz > 4096 ? (float)sz > 0.4f * (float)this._floats.length : (float)sz > 2.0f * (float)this._floats.length))) {
                this.condense();
            }
        }
    }

    @Override
    public synchronized float[] expand() {
        float[] all = super.expand();
        for (int idx : this._map.keySet()) {
            float val;
            all[idx] = val = this._map.get(idx).floatValue();
        }
        return all;
    }

    public synchronized void condense() {
        super.condense(this.expand());
        this._map = new Hashtable<Integer, Float>();
    }
}

