// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.data.tables.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * Table Service Properties.
 */
@Fluent
public final class TableServiceProperties implements XmlSerializable<TableServiceProperties> {

    /*
     * Azure Analytics Logging settings.
     */
    private TableServiceLogging logging;

    /*
     * A summary of request statistics grouped by API in hourly aggregates for tables.
     */
    private TableServiceMetrics hourMetrics;

    /*
     * A summary of request statistics grouped by API in minute aggregates for tables.
     */
    private TableServiceMetrics minuteMetrics;

    /*
     * The set of CORS rules.
     */
    private List<TableServiceCorsRule> cors;

    /**
     * Creates an instance of TableServiceProperties class.
     */
    public TableServiceProperties() {
    }

    /**
     * Get the logging property: Azure Analytics Logging settings.
     *
     * @return the logging value.
     */
    public TableServiceLogging getLogging() {
        return this.logging;
    }

    /**
     * Set the logging property: Azure Analytics Logging settings.
     *
     * @param logging the logging value to set.
     * @return the TableServiceProperties object itself.
     */
    public TableServiceProperties setLogging(TableServiceLogging logging) {
        this.logging = logging;
        return this;
    }

    /**
     * Get the hourMetrics property: A summary of request statistics grouped by API in hourly aggregates for tables.
     *
     * @return the hourMetrics value.
     */
    public TableServiceMetrics getHourMetrics() {
        return this.hourMetrics;
    }

    /**
     * Set the hourMetrics property: A summary of request statistics grouped by API in hourly aggregates for tables.
     *
     * @param hourMetrics the hourMetrics value to set.
     * @return the TableServiceProperties object itself.
     */
    public TableServiceProperties setHourMetrics(TableServiceMetrics hourMetrics) {
        this.hourMetrics = hourMetrics;
        return this;
    }

    /**
     * Get the minuteMetrics property: A summary of request statistics grouped by API in minute aggregates for tables.
     *
     * @return the minuteMetrics value.
     */
    public TableServiceMetrics getMinuteMetrics() {
        return this.minuteMetrics;
    }

    /**
     * Set the minuteMetrics property: A summary of request statistics grouped by API in minute aggregates for tables.
     *
     * @param minuteMetrics the minuteMetrics value to set.
     * @return the TableServiceProperties object itself.
     */
    public TableServiceProperties setMinuteMetrics(TableServiceMetrics minuteMetrics) {
        this.minuteMetrics = minuteMetrics;
        return this;
    }

    /**
     * Get the cors property: The set of CORS rules.
     *
     * @return the cors value.
     */
    public List<TableServiceCorsRule> getCorsRules() {
        return this.cors;
    }

    /**
     * Set the cors property: The set of CORS rules.
     *
     * @param cors the cors value to set.
     * @return the TableServiceProperties object itself.
     */
    public TableServiceProperties setCorsRules(List<TableServiceCorsRule> cors) {
        this.cors = cors;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "StorageServiceProperties" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeXml(this.logging, "Logging");
        xmlWriter.writeXml(this.hourMetrics, "HourMetrics");
        xmlWriter.writeXml(this.minuteMetrics, "MinuteMetrics");
        if (this.cors != null) {
            xmlWriter.writeStartElement("Cors");
            for (TableServiceCorsRule element : this.cors) {
                xmlWriter.writeXml(element, "CorsRule");
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of TableServiceProperties from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @return An instance of TableServiceProperties if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the TableServiceProperties.
     */
    public static TableServiceProperties fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of TableServiceProperties from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of TableServiceProperties if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the TableServiceProperties.
     */
    public static TableServiceProperties fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        String finalRootElementName
            = CoreUtils.isNullOrEmpty(rootElementName) ? "StorageServiceProperties" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            TableServiceProperties deserializedTableServiceProperties = new TableServiceProperties();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Logging".equals(elementName.getLocalPart())) {
                    deserializedTableServiceProperties.logging = TableServiceLogging.fromXml(reader, "Logging");
                } else if ("HourMetrics".equals(elementName.getLocalPart())) {
                    deserializedTableServiceProperties.hourMetrics = TableServiceMetrics.fromXml(reader, "HourMetrics");
                } else if ("MinuteMetrics".equals(elementName.getLocalPart())) {
                    deserializedTableServiceProperties.minuteMetrics
                        = TableServiceMetrics.fromXml(reader, "MinuteMetrics");
                } else if ("Cors".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("CorsRule".equals(elementName.getLocalPart())) {
                            if (deserializedTableServiceProperties.cors == null) {
                                deserializedTableServiceProperties.cors = new ArrayList<>();
                            }
                            deserializedTableServiceProperties.cors
                                .add(TableServiceCorsRule.fromXml(reader, "CorsRule"));
                        } else {
                            reader.skipElement();
                        }
                    }
                } else {
                    reader.skipElement();
                }
            }
            return deserializedTableServiceProperties;
        });
    }
}
