// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.tables.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The service OData error message.
 */
@Fluent
public final class TableServiceOdataErrorMessage implements JsonSerializable<TableServiceOdataErrorMessage> {
    /*
     * Language code of the error message.
     */
    private String lang;

    /*
     * The error message
     */
    private String value;

    /**
     * Creates an instance of TableServiceOdataErrorMessage class.
     */
    public TableServiceOdataErrorMessage() {
    }

    /**
     * Get the lang property: Language code of the error message.
     * 
     * @return the lang value.
     */
    public String getLang() {
        return this.lang;
    }

    /**
     * Set the lang property: Language code of the error message.
     * 
     * @param lang the lang value to set.
     * @return the TableServiceOdataErrorMessage object itself.
     */
    public TableServiceOdataErrorMessage setLang(String lang) {
        this.lang = lang;
        return this;
    }

    /**
     * Get the value property: The error message.
     * 
     * @return the value value.
     */
    public String getValue() {
        return this.value;
    }

    /**
     * Set the value property: The error message.
     * 
     * @param value the value value to set.
     * @return the TableServiceOdataErrorMessage object itself.
     */
    public TableServiceOdataErrorMessage setValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lang", this.lang);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TableServiceOdataErrorMessage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TableServiceOdataErrorMessage if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TableServiceOdataErrorMessage.
     */
    public static TableServiceOdataErrorMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TableServiceOdataErrorMessage deserializedTableServiceOdataErrorMessage
                = new TableServiceOdataErrorMessage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("lang".equals(fieldName)) {
                    deserializedTableServiceOdataErrorMessage.lang = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedTableServiceOdataErrorMessage.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTableServiceOdataErrorMessage;
        });
    }
}
