/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.StrictListAccessor;
import lombok.ast.StringLiteral;

public class CipherGetInstanceDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"GetInstance", (String)"Cipher.getInstance with ECB", (String)"`Cipher#getInstance` should not be called with ECB as the cipher mode or without setting the cipher mode because the default mode on android is ECB, which is insecure.", (Category)Category.SECURITY, (int)9, (Severity)Severity.WARNING, (Implementation)new Implementation(CipherGetInstanceDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final String CIPHER = "javax.crypto.Cipher";
    private static final String GET_INSTANCE = "getInstance";
    private static final Set<String> ALGORITHM_ONLY = Sets.newHashSet((Object[])new String[]{"AES", "DES", "DESede"});
    private static final String ECB = "ECB";

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Nullable
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(GET_INSTANCE);
    }

    public void visitMethod(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull MethodInvocation node) {
        JavaParser.ResolvedNode resolved = context.resolve((Node)node);
        if (!(resolved instanceof JavaParser.ResolvedMethod)) {
            return;
        }
        JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
        if (!method.getContainingClass().isSubclassOf(CIPHER, false)) {
            return;
        }
        StrictListAccessor argumentList = node.astArguments();
        if (argumentList != null && argumentList.size() == 1) {
            Expression expression = (Expression)argumentList.first();
            if (expression instanceof StringLiteral) {
                StringLiteral argument = (StringLiteral)expression;
                String parameter = argument.astValue();
                CipherGetInstanceDetector.checkParameter(context, node, (Node)argument, parameter, false);
            } else {
                JavaParser.ResolvedField field;
                Object value;
                JavaParser.ResolvedNode resolve = context.resolve((Node)expression);
                if (resolve instanceof JavaParser.ResolvedField && (value = (field = (JavaParser.ResolvedField)resolve).getValue()) instanceof String) {
                    CipherGetInstanceDetector.checkParameter(context, node, (Node)expression, (String)value, true);
                }
            }
        }
    }

    private static void checkParameter(@NonNull JavaContext context, @NonNull MethodInvocation call, @NonNull Node node, @NonNull String value, boolean includeValue) {
        if (ALGORITHM_ONLY.contains(value)) {
            String message = "`Cipher.getInstance` should not be called without setting the encryption mode and padding";
            context.report(ISSUE, (Node)call, context.getLocation(node), message);
        } else if (value.contains(ECB)) {
            String message = "ECB encryption mode should not be used";
            if (includeValue) {
                message = message + " (was \"" + value + "\")";
            }
            context.report(ISSUE, (Node)call, context.getLocation(node), message);
        }
    }
}

