/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.Collections;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.ClassDeclaration;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;

public class ViewConstructorDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"ViewConstructor", (String)"Missing View constructors for XML inflation", (String)"Checks that custom views define the expected constructors", (String)"Some layout tools (such as the Android layout editor for Studio & Eclipse) needs to find a constructor with one of the following signatures:\n* `View(Context context)`\n* `View(Context context, AttributeSet attrs)`\n* `View(Context context, AttributeSet attrs, int defStyle)`\n\nIf your custom view needs to perform initialization which does not apply when used in a layout editor, you can surround the given code with a check to see if `View#isInEditMode()` is false, since that method will return `false` at runtime but true within a user interface editor.", (Category)Category.USABILITY, (int)3, (Severity)Severity.WARNING, (Implementation)new Implementation(ViewConstructorDetector.class, Scope.JAVA_FILE_SCOPE));

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Nullable
    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Collections.singletonList(ClassDeclaration.class);
    }

    @Nullable
    public AstVisitor createJavaVisitor(@NonNull JavaContext context) {
        return new ViewConstructorVisitor(context);
    }

    private static boolean isXmlConstructor(JavaParser.ResolvedMethod method) {
        int argumentCount = method.getArgumentCount();
        if (argumentCount == 0 || argumentCount > 3) {
            return false;
        }
        if (!method.getArgumentType(0).matchesName("android.content.Context")) {
            return false;
        }
        if (argumentCount == 1) {
            return true;
        }
        if (!method.getArgumentType(1).matchesName("android.util.AttributeSet")) {
            return false;
        }
        if (argumentCount == 2) {
            return true;
        }
        return method.getArgumentType(2).matchesName("int");
    }

    private static class ViewConstructorVisitor
    extends ForwardingAstVisitor {
        private final JavaContext mContext;

        public ViewConstructorVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitClassDeclaration(ClassDeclaration node) {
            int flags = node.astModifiers().getEffectiveModifierFlags();
            if ((flags & 0x400) != 0) {
                return true;
            }
            if (node.getParent() instanceof NormalTypeBody && (flags & 8) == 0) {
                return true;
            }
            JavaParser.ResolvedNode resolved = this.mContext.resolve((Node)node);
            if (!(resolved instanceof JavaParser.ResolvedClass)) {
                return true;
            }
            JavaParser.ResolvedClass cls = (JavaParser.ResolvedClass)resolved;
            if (!cls.isSubclassOf("android.view.View", false)) {
                return true;
            }
            boolean found = false;
            for (JavaParser.ResolvedMethod constructor : cls.getConstructors()) {
                if (!ViewConstructorDetector.isXmlConstructor(constructor)) continue;
                found = true;
                break;
            }
            if (!found) {
                String message = String.format("Custom view %1$s is missing constructor used by tools: (Context) or (Context,AttributeSet) or (Context,AttributeSet,int)", node.astName().astValue());
                Location location = this.mContext.getLocation((Node)node.astName());
                this.mContext.report(ISSUE, (Node)node, location, message, null);
            }
            return true;
        }
    }
}

