/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.ast.ArrayAccess;
import lombok.ast.AstVisitor;
import lombok.ast.BinaryExpression;
import lombok.ast.Cast;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.If;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Select;
import lombok.ast.Statement;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;

public class CutPasteDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"CutPasteId", (String)"Likely cut & paste mistakes", (String)"Looks for code cut & paste mistakes in `findViewById()` calls", (String)"This lint check looks for cases where you have cut & pasted calls to `findViewById` but have forgotten to update the R.id field. It's possible that your code is simply (redundantly) looking up the field repeatedly, but lint cannot distinguish that from a case where you for example want to initialize fields `prev` and `next` and you cut & pasted `findViewById(R.id.prev)` and forgot to update the second initialization to `R.id.next`.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(CutPasteDetector.class, Scope.JAVA_FILE_SCOPE));
    private Node mLastMethod;
    private Map<String, MethodInvocation> mIds;
    private Map<String, String> mLhs;
    private Map<String, String> mCallOperands;

    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("findViewById");
    }

    public void visitMethod(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull MethodInvocation call) {
        String lhs = CutPasteDetector.getLhs(call);
        if (lhs == null) {
            return;
        }
        Node method = JavaContext.findSurroundingMethod((Node)call);
        if (method == null) {
            return;
        }
        if (method != this.mLastMethod) {
            this.mIds = Maps.newHashMap();
            this.mLhs = Maps.newHashMap();
            this.mCallOperands = Maps.newHashMap();
            this.mLastMethod = method;
        }
        String callOperand = call.astOperand() != null ? call.astOperand().toString() : "";
        Expression first = (Expression)call.astArguments().first();
        if (first instanceof Select) {
            Select type;
            Select select = (Select)first;
            String id = select.astIdentifier().astValue();
            Expression operand = select.astOperand();
            if (operand instanceof Select && (type = (Select)operand).astIdentifier().astValue().equals("id")) {
                if (this.mIds.containsKey(id)) {
                    if (lhs.equals(this.mLhs.get(id))) {
                        return;
                    }
                    if (!callOperand.equals(this.mCallOperands.get(id))) {
                        return;
                    }
                    MethodInvocation earlierCall = this.mIds.get(id);
                    if (!CutPasteDetector.isReachableFrom(method, earlierCall, call)) {
                        return;
                    }
                    Location location = context.getLocation((Node)call);
                    Location secondary = context.getLocation((Node)earlierCall);
                    secondary.setMessage("First usage here");
                    location.setSecondary(secondary);
                    context.report(ISSUE, (Node)call, location, String.format("The id %1$s has already been looked up in this method; possible cut & paste error?", first.toString()), null);
                } else {
                    this.mIds.put(id, call);
                    this.mLhs.put(id, lhs);
                    this.mCallOperands.put(id, callOperand);
                }
            }
        }
    }

    @Nullable
    private static String getLhs(@NonNull MethodInvocation call) {
        Node parent = call.getParent();
        if (parent instanceof Cast) {
            parent = parent.getParent();
        }
        if (parent instanceof VariableDefinitionEntry) {
            VariableDefinitionEntry vde = (VariableDefinitionEntry)parent;
            return vde.astName().astValue();
        }
        if (parent instanceof BinaryExpression) {
            BinaryExpression be = (BinaryExpression)parent;
            Expression left = be.astLeft();
            if (left instanceof VariableReference || left instanceof Select) {
                return be.astLeft().toString();
            }
            if (left instanceof ArrayAccess) {
                ArrayAccess aa = (ArrayAccess)left;
                return aa.astOperand().toString();
            }
        }
        return null;
    }

    private static boolean isReachableFrom(@NonNull Node method, @NonNull MethodInvocation from, @NonNull MethodInvocation to) {
        ReachableVisitor visitor = new ReachableVisitor(from, to);
        method.accept((AstVisitor)visitor);
        return visitor.isReachable();
    }

    private static class ReachableVisitor
    extends ForwardingAstVisitor {
        @NonNull
        private final MethodInvocation mFrom;
        @NonNull
        private final MethodInvocation mTo;
        private boolean mReachable;
        private boolean mSeenEnd;

        public ReachableVisitor(@NonNull MethodInvocation from, @NonNull MethodInvocation to) {
            this.mFrom = from;
            this.mTo = to;
        }

        boolean isReachable() {
            return this.mReachable;
        }

        public boolean visitMethodInvocation(MethodInvocation node) {
            if (node == this.mFrom) {
                this.mReachable = true;
            } else if (node == this.mTo) {
                this.mSeenEnd = true;
            }
            return super.visitMethodInvocation(node);
        }

        public boolean visitIf(If node) {
            boolean wasReachable;
            Expression condition = node.astCondition();
            Statement body = node.astStatement();
            Statement elseBody = node.astElseStatement();
            if (condition != null) {
                condition.accept((AstVisitor)this);
            }
            if (body != null) {
                wasReachable = this.mReachable;
                body.accept((AstVisitor)this);
                this.mReachable = wasReachable;
            }
            if (elseBody != null) {
                wasReachable = this.mReachable;
                elseBody.accept((AstVisitor)this);
                this.mReachable = wasReachable;
            }
            this.endVisit((Node)node);
            return false;
        }

        public boolean visitNode(Node node) {
            return this.mSeenEnd;
        }
    }
}

