/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.matchers;

import lombok.ast.libs.org.parboiled.MatcherContext;
import lombok.ast.libs.org.parboiled.matchers.AbstractMatcher;
import lombok.ast.libs.org.parboiled.matchers.MatcherVisitor;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharIgnoreCaseMatcher<V>
extends AbstractMatcher<V> {
    public final char charLow;
    public final char charUp;

    public CharIgnoreCaseMatcher(char character) {
        this.charLow = Character.toLowerCase(character);
        this.charUp = Character.toUpperCase(character);
    }

    @Override
    public boolean match(@NotNull MatcherContext<V> context) {
        if (context == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.matchers.CharIgnoreCaseMatcher.match(...) corresponds to @NotNull parameter and must not be null");
        }
        char c = context.getCurrentChar();
        if (c != this.charLow && c != this.charUp) {
            return false;
        }
        context.advanceIndex();
        context.createNode();
        return true;
    }

    @Override
    public <R> R accept(@NotNull MatcherVisitor<V, R> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.matchers.CharIgnoreCaseMatcher.accept(...) corresponds to @NotNull parameter and must not be null");
        }
        return visitor.visit(this);
    }
}

