/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.ast.libs.org.parboiled.Action;
import lombok.ast.libs.org.parboiled.Rule;
import lombok.ast.libs.org.parboiled.common.StringUtils;
import lombok.ast.libs.org.parboiled.matchers.ActionMatcher;
import lombok.ast.libs.org.parboiled.matchers.AnyMatcher;
import lombok.ast.libs.org.parboiled.matchers.CharIgnoreCaseMatcher;
import lombok.ast.libs.org.parboiled.matchers.CharMatcher;
import lombok.ast.libs.org.parboiled.matchers.CharRangeMatcher;
import lombok.ast.libs.org.parboiled.matchers.CharSetMatcher;
import lombok.ast.libs.org.parboiled.matchers.CustomMatcher;
import lombok.ast.libs.org.parboiled.matchers.EmptyMatcher;
import lombok.ast.libs.org.parboiled.matchers.FirstOfMatcher;
import lombok.ast.libs.org.parboiled.matchers.Matcher;
import lombok.ast.libs.org.parboiled.matchers.MatcherVisitor;
import lombok.ast.libs.org.parboiled.matchers.OneOrMoreMatcher;
import lombok.ast.libs.org.parboiled.matchers.OptionalMatcher;
import lombok.ast.libs.org.parboiled.matchers.ProxyMatcher;
import lombok.ast.libs.org.parboiled.matchers.SequenceMatcher;
import lombok.ast.libs.org.parboiled.matchers.TestMatcher;
import lombok.ast.libs.org.parboiled.matchers.TestNotMatcher;
import lombok.ast.libs.org.parboiled.matchers.VarFramingMatcher;
import lombok.ast.libs.org.parboiled.matchers.ZeroOrMoreMatcher;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserStatistics<V>
implements MatcherVisitor<V, ParserStatistics> {
    private final Matcher<V> root;
    private int totalRules;
    private final Set<AnyMatcher<V>> anyMatchers = new HashSet<AnyMatcher<V>>();
    private final Set<CharIgnoreCaseMatcher<V>> charIgnoreCaseMatchers = new HashSet<CharIgnoreCaseMatcher<V>>();
    private final Set<CharMatcher<V>> charMatchers = new HashSet<CharMatcher<V>>();
    private final Set<CustomMatcher<V>> customMatchers = new HashSet<CustomMatcher<V>>();
    private final Set<CharRangeMatcher<V>> charRangeMatchers = new HashSet<CharRangeMatcher<V>>();
    private final Set<CharSetMatcher<V>> charSetMatchers = new HashSet<CharSetMatcher<V>>();
    private final Set<EmptyMatcher<V>> emptyMatchers = new HashSet<EmptyMatcher<V>>();
    private final Set<FirstOfMatcher<V>> firstOfMatchers = new HashSet<FirstOfMatcher<V>>();
    private final Set<OneOrMoreMatcher<V>> oneOrMoreMatchers = new HashSet<OneOrMoreMatcher<V>>();
    private final Set<OptionalMatcher<V>> optionalMatchers = new HashSet<OptionalMatcher<V>>();
    private final Set<SequenceMatcher<V>> sequenceMatchers = new HashSet<SequenceMatcher<V>>();
    private final Set<TestMatcher<V>> testMatchers = new HashSet<TestMatcher<V>>();
    private final Set<TestNotMatcher<V>> testNotMatchers = new HashSet<TestNotMatcher<V>>();
    private final Set<ZeroOrMoreMatcher<V>> zeroOrMoreMatchers = new HashSet<ZeroOrMoreMatcher<V>>();
    private final Set<Action<V>> actions = new HashSet<Action<V>>();
    private final Set<Class<?>> actionClasses = new HashSet();
    private final Set<ProxyMatcher<V>> proxyMatchers = new HashSet<ProxyMatcher<V>>();
    private final Set<VarFramingMatcher<V>> varFramingMatchers = new HashSet<VarFramingMatcher<V>>();

    public static <V> ParserStatistics<V> generateFor(@NotNull Rule rule) {
        if (rule == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.ParserStatistics.generateFor(...) corresponds to @NotNull parameter and must not be null");
        }
        Matcher matcher = (Matcher)rule;
        return (ParserStatistics)matcher.accept(new ParserStatistics<V>(matcher));
    }

    private ParserStatistics(Matcher<V> root) {
        this.root = root;
        this.countSpecials(root);
    }

    public Rule getRootRule() {
        return this.root;
    }

    public int getTotalRules() {
        return this.totalRules;
    }

    public Set<AnyMatcher<V>> getAnyMatchers() {
        return this.anyMatchers;
    }

    public Set<CharIgnoreCaseMatcher<V>> getCharIgnoreCaseMatchers() {
        return this.charIgnoreCaseMatchers;
    }

    public Set<CharMatcher<V>> getCharMatchers() {
        return this.charMatchers;
    }

    public Set<CustomMatcher<V>> getCustomMatchers() {
        return this.customMatchers;
    }

    public Set<CharRangeMatcher<V>> getCharRangeMatchers() {
        return this.charRangeMatchers;
    }

    public Set<CharSetMatcher<V>> getCharSetMatchers() {
        return this.charSetMatchers;
    }

    public Set<EmptyMatcher<V>> getEmptyMatchers() {
        return this.emptyMatchers;
    }

    public Set<FirstOfMatcher<V>> getFirstOfMatchers() {
        return this.firstOfMatchers;
    }

    public Set<OneOrMoreMatcher<V>> getOneOrMoreMatchers() {
        return this.oneOrMoreMatchers;
    }

    public Set<OptionalMatcher<V>> getOptionalMatchers() {
        return this.optionalMatchers;
    }

    public Set<SequenceMatcher<V>> getSequenceMatchers() {
        return this.sequenceMatchers;
    }

    public Set<TestMatcher<V>> getTestMatchers() {
        return this.testMatchers;
    }

    public Set<TestNotMatcher<V>> getTestNotMatchers() {
        return this.testNotMatchers;
    }

    public Set<ZeroOrMoreMatcher<V>> getZeroOrMoreMatchers() {
        return this.zeroOrMoreMatchers;
    }

    public Set<Action<V>> getActions() {
        return this.actions;
    }

    public Set<Class<?>> getActionClasses() {
        return this.actionClasses;
    }

    public Set<ProxyMatcher<V>> getProxyMatchers() {
        return this.proxyMatchers;
    }

    public Set<VarFramingMatcher<V>> getVarFramingMatchers() {
        return this.varFramingMatchers;
    }

    @Override
    public ParserStatistics<V> visit(ActionMatcher<V> matcher) {
        if (!this.actions.contains(matcher.action)) {
            ++this.totalRules;
            this.actions.add(matcher.action);
            this.actionClasses.add(matcher.action.getClass());
        }
        return this;
    }

    @Override
    public ParserStatistics<V> visit(AnyMatcher<V> matcher) {
        return this.visit(matcher, this.anyMatchers);
    }

    @Override
    public ParserStatistics<V> visit(CharIgnoreCaseMatcher<V> matcher) {
        return this.visit(matcher, this.charIgnoreCaseMatchers);
    }

    @Override
    public ParserStatistics<V> visit(CharMatcher<V> matcher) {
        return this.visit(matcher, this.charMatchers);
    }

    @Override
    public ParserStatistics<V> visit(CustomMatcher<V> matcher) {
        return this.visit(matcher, this.customMatchers);
    }

    @Override
    public ParserStatistics<V> visit(CharRangeMatcher<V> matcher) {
        return this.visit(matcher, this.charRangeMatchers);
    }

    @Override
    public ParserStatistics<V> visit(CharSetMatcher<V> matcher) {
        return this.visit(matcher, this.charSetMatchers);
    }

    @Override
    public ParserStatistics<V> visit(EmptyMatcher<V> matcher) {
        return this.visit(matcher, this.emptyMatchers);
    }

    @Override
    public ParserStatistics<V> visit(FirstOfMatcher<V> matcher) {
        return this.visit(matcher, this.firstOfMatchers);
    }

    @Override
    public ParserStatistics<V> visit(OneOrMoreMatcher<V> matcher) {
        return this.visit(matcher, this.oneOrMoreMatchers);
    }

    @Override
    public ParserStatistics<V> visit(OptionalMatcher<V> matcher) {
        return this.visit(matcher, this.optionalMatchers);
    }

    @Override
    public ParserStatistics<V> visit(SequenceMatcher<V> matcher) {
        return this.visit(matcher, this.sequenceMatchers);
    }

    @Override
    public ParserStatistics<V> visit(TestMatcher<V> matcher) {
        return this.visit(matcher, this.testMatchers);
    }

    @Override
    public ParserStatistics<V> visit(TestNotMatcher<V> matcher) {
        return this.visit(matcher, this.testNotMatchers);
    }

    @Override
    public ParserStatistics<V> visit(ZeroOrMoreMatcher<V> matcher) {
        return this.visit(matcher, this.zeroOrMoreMatchers);
    }

    private <M extends Matcher<V>> ParserStatistics<V> visit(M matcher, Set<M> set) {
        if (!set.contains(matcher)) {
            ++this.totalRules;
            set.add(matcher);
            for (Matcher child : matcher.getChildren()) {
                this.countSpecials(child);
                child.accept(this);
            }
        }
        return this;
    }

    private void countSpecials(Matcher<V> matcher) {
        if (matcher instanceof ProxyMatcher) {
            this.proxyMatchers.add((ProxyMatcher)matcher);
        } else if (matcher instanceof VarFramingMatcher) {
            this.varFramingMatchers.add((VarFramingMatcher)matcher);
        }
    }

    public String toString() {
        return "Parser statistics for rule '" + this.root + "':\n" + "    Total rules       : " + this.totalRules + '\n' + "        Actions       : " + this.actions.size() + '\n' + "        Any           : " + this.anyMatchers.size() + '\n' + "        CharIgnoreCase: " + this.charIgnoreCaseMatchers.size() + '\n' + "        Char          : " + this.charMatchers.size() + '\n' + "        Custom        : " + this.customMatchers.size() + '\n' + "        CharRange     : " + this.charRangeMatchers.size() + '\n' + "        CharSet       : " + this.charSetMatchers.size() + '\n' + "        Empty         : " + this.emptyMatchers.size() + '\n' + "        FirstOf       : " + this.firstOfMatchers.size() + '\n' + "        OneOrMore     : " + this.oneOrMoreMatchers.size() + '\n' + "        Optional      : " + this.optionalMatchers.size() + '\n' + "        Sequence      : " + this.sequenceMatchers.size() + '\n' + "        Test          : " + this.testMatchers.size() + '\n' + "        TestNot       : " + this.testNotMatchers.size() + '\n' + "        ZeroOrMore    : " + this.zeroOrMoreMatchers.size() + '\n' + '\n' + "    Action Classes    : " + this.actionClasses.size() + '\n' + "    ProxyMatchers     : " + this.proxyMatchers.size() + '\n' + "    VarFramingMatchers: " + this.varFramingMatchers.size() + '\n';
    }

    public String printActionClassInstances() {
        StringBuilder stringBuilder = new StringBuilder("Action classes and their instances for rule '").append(this.root).append("':\n");
        for (String string : this.printActionClassLines()) {
            stringBuilder.append("    ").append(string).append('\n');
        }
        return stringBuilder.toString();
    }

    private List<String> printActionClassLines() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (Class<?> clazz : this.actionClasses) {
            String string = clazz.getSimpleName();
            if (StringUtils.isEmpty(string)) {
                ++n;
                continue;
            }
            arrayList.add(string + " : " + StringUtils.join(this.printActionClassInstances(clazz), ", "));
        }
        Collections.sort(arrayList);
        if (n > 0) {
            arrayList.add("and " + n + " anonymous instance(s)");
        }
        return arrayList;
    }

    private List<String> printActionClassInstances(Class<?> actionClass) {
        ArrayList<String> actionNames = new ArrayList<String>();
        for (Action<V> action : this.actions) {
            if (!action.getClass().equals(actionClass)) continue;
            actionNames.add(action.toString());
        }
        Collections.sort(actionNames);
        return actionNames;
    }
}

