/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.Catch;
import lombok.ast.ListAccessor;
import lombok.ast.Node;
import lombok.ast.RawListAccessor;
import lombok.ast.Statement;
import lombok.ast.StrictListAccessor;

public class Try
extends AbstractNode
implements Statement {
    private AbstractNode body = null;
    ListAccessor<Catch, Try> catches = ListAccessor.of(this, Catch.class, "Try.catches");
    private AbstractNode finally_ = null;

    @Override
    public Block upToBlock() {
        if (!(this.getParent() instanceof Block)) {
            return null;
        }
        Block out = (Block)this.getParent();
        if (!out.rawContents().contains(this)) {
            return null;
        }
        return out;
    }

    public Block astBody() {
        if (!(this.body instanceof Block)) {
            return null;
        }
        return (Block)this.body;
    }

    public Try astBody(Block body) {
        if (body == null) {
            throw new NullPointerException("body is mandatory");
        }
        return this.rawBody(body);
    }

    public Node rawBody() {
        return this.body;
    }

    public Try rawBody(Node body) {
        if (body == this.body) {
            return this;
        }
        if (body != null) {
            this.adopt((AbstractNode)body);
        }
        if (this.body != null) {
            this.disown(this.body);
        }
        this.body = (AbstractNode)body;
        return this;
    }

    public RawListAccessor<Catch, Try> rawCatches() {
        return this.catches.asRaw();
    }

    public StrictListAccessor<Catch, Try> astCatches() {
        return this.catches.asStrict();
    }

    public Block astFinally() {
        if (!(this.finally_ instanceof Block)) {
            return null;
        }
        return (Block)this.finally_;
    }

    public Try astFinally(Block finally_) {
        return this.rawFinally(finally_);
    }

    public Node rawFinally() {
        return this.finally_;
    }

    public Try rawFinally(Node finally_) {
        if (finally_ == this.finally_) {
            return this;
        }
        if (finally_ != null) {
            this.adopt((AbstractNode)finally_);
        }
        if (this.finally_ != null) {
            this.disown(this.finally_);
        }
        this.finally_ = (AbstractNode)finally_;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.body != null) {
            result.add(this.body);
        }
        result.addAll(this.catches.backingList());
        if (this.finally_ != null) {
            result.add(this.finally_);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.body == original) {
            this.rawBody(replacement);
            return true;
        }
        if (this.rawCatches().replace(original, replacement)) {
            return true;
        }
        if (this.finally_ == original) {
            this.rawFinally(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.body == child) {
            this.disown((AbstractNode)child);
            this.body = null;
            return true;
        }
        if (this.rawCatches().remove(child)) {
            return true;
        }
        if (this.finally_ == child) {
            this.disown((AbstractNode)child);
            this.finally_ = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitTry(this)) {
            return;
        }
        if (this.body != null) {
            this.body.accept(visitor);
        }
        for (AbstractNode child : this.catches.asIterable()) {
            child.accept(visitor);
        }
        if (this.finally_ != null) {
            this.finally_.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public Try copy() {
        Try result = new Try();
        if (this.body != null) {
            result.rawBody(this.body.copy());
        }
        for (AbstractNode n : this.catches.backingList()) {
            result.rawCatches().addToEnd(n == null ? null : n.copy());
        }
        if (this.finally_ != null) {
            result.rawFinally(this.finally_.copy());
        }
        return result;
    }
}

