/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.trustedadvisor.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendations"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListOrganizationRecommendationsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The list of Recommendations
     * </p>
     */
    private java.util.List<OrganizationRecommendationSummary> organizationRecommendationSummaries;

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @param nextToken
     *        The token for the next set of results. Use the value returned in the previous response in the next request
     *        to retrieve the next set of results.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @param nextToken
     *        The token for the next set of results. Use the value returned in the previous response in the next request
     *        to retrieve the next set of results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListOrganizationRecommendationsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The list of Recommendations
     * </p>
     * 
     * @return The list of Recommendations
     */

    public java.util.List<OrganizationRecommendationSummary> getOrganizationRecommendationSummaries() {
        return organizationRecommendationSummaries;
    }

    /**
     * <p>
     * The list of Recommendations
     * </p>
     * 
     * @param organizationRecommendationSummaries
     *        The list of Recommendations
     */

    public void setOrganizationRecommendationSummaries(java.util.Collection<OrganizationRecommendationSummary> organizationRecommendationSummaries) {
        if (organizationRecommendationSummaries == null) {
            this.organizationRecommendationSummaries = null;
            return;
        }

        this.organizationRecommendationSummaries = new java.util.ArrayList<OrganizationRecommendationSummary>(organizationRecommendationSummaries);
    }

    /**
     * <p>
     * The list of Recommendations
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setOrganizationRecommendationSummaries(java.util.Collection)} or
     * {@link #withOrganizationRecommendationSummaries(java.util.Collection)} if you want to override the existing
     * values.
     * </p>
     * 
     * @param organizationRecommendationSummaries
     *        The list of Recommendations
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListOrganizationRecommendationsResult withOrganizationRecommendationSummaries(
            OrganizationRecommendationSummary... organizationRecommendationSummaries) {
        if (this.organizationRecommendationSummaries == null) {
            setOrganizationRecommendationSummaries(new java.util.ArrayList<OrganizationRecommendationSummary>(organizationRecommendationSummaries.length));
        }
        for (OrganizationRecommendationSummary ele : organizationRecommendationSummaries) {
            this.organizationRecommendationSummaries.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The list of Recommendations
     * </p>
     * 
     * @param organizationRecommendationSummaries
     *        The list of Recommendations
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListOrganizationRecommendationsResult withOrganizationRecommendationSummaries(
            java.util.Collection<OrganizationRecommendationSummary> organizationRecommendationSummaries) {
        setOrganizationRecommendationSummaries(organizationRecommendationSummaries);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getOrganizationRecommendationSummaries() != null)
            sb.append("OrganizationRecommendationSummaries: ").append(getOrganizationRecommendationSummaries());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListOrganizationRecommendationsResult == false)
            return false;
        ListOrganizationRecommendationsResult other = (ListOrganizationRecommendationsResult) obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getOrganizationRecommendationSummaries() == null ^ this.getOrganizationRecommendationSummaries() == null)
            return false;
        if (other.getOrganizationRecommendationSummaries() != null
                && other.getOrganizationRecommendationSummaries().equals(this.getOrganizationRecommendationSummaries()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getOrganizationRecommendationSummaries() == null) ? 0 : getOrganizationRecommendationSummaries().hashCode());
        return hashCode;
    }

    @Override
    public ListOrganizationRecommendationsResult clone() {
        try {
            return (ListOrganizationRecommendationsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
