/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamquery;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.timestreamquery.AmazonTimestreamQuery;
import com.amazonaws.services.timestreamquery.AmazonTimestreamQueryClientBuilder;
import com.amazonaws.services.timestreamquery.endpointdiscovery.AmazonTimestreamQueryEndpointCache;
import com.amazonaws.services.timestreamquery.model.AmazonTimestreamQueryException;
import com.amazonaws.services.timestreamquery.model.CancelQueryRequest;
import com.amazonaws.services.timestreamquery.model.CancelQueryResult;
import com.amazonaws.services.timestreamquery.model.CreateScheduledQueryRequest;
import com.amazonaws.services.timestreamquery.model.CreateScheduledQueryResult;
import com.amazonaws.services.timestreamquery.model.DeleteScheduledQueryRequest;
import com.amazonaws.services.timestreamquery.model.DeleteScheduledQueryResult;
import com.amazonaws.services.timestreamquery.model.DescribeAccountSettingsRequest;
import com.amazonaws.services.timestreamquery.model.DescribeAccountSettingsResult;
import com.amazonaws.services.timestreamquery.model.DescribeEndpointsRequest;
import com.amazonaws.services.timestreamquery.model.DescribeEndpointsResult;
import com.amazonaws.services.timestreamquery.model.DescribeScheduledQueryRequest;
import com.amazonaws.services.timestreamquery.model.DescribeScheduledQueryResult;
import com.amazonaws.services.timestreamquery.model.ExecuteScheduledQueryRequest;
import com.amazonaws.services.timestreamquery.model.ExecuteScheduledQueryResult;
import com.amazonaws.services.timestreamquery.model.ListScheduledQueriesRequest;
import com.amazonaws.services.timestreamquery.model.ListScheduledQueriesResult;
import com.amazonaws.services.timestreamquery.model.ListTagsForResourceRequest;
import com.amazonaws.services.timestreamquery.model.ListTagsForResourceResult;
import com.amazonaws.services.timestreamquery.model.PrepareQueryRequest;
import com.amazonaws.services.timestreamquery.model.PrepareQueryResult;
import com.amazonaws.services.timestreamquery.model.QueryRequest;
import com.amazonaws.services.timestreamquery.model.QueryResult;
import com.amazonaws.services.timestreamquery.model.TagResourceRequest;
import com.amazonaws.services.timestreamquery.model.TagResourceResult;
import com.amazonaws.services.timestreamquery.model.UntagResourceRequest;
import com.amazonaws.services.timestreamquery.model.UntagResourceResult;
import com.amazonaws.services.timestreamquery.model.UpdateAccountSettingsRequest;
import com.amazonaws.services.timestreamquery.model.UpdateAccountSettingsResult;
import com.amazonaws.services.timestreamquery.model.UpdateScheduledQueryRequest;
import com.amazonaws.services.timestreamquery.model.UpdateScheduledQueryResult;
import com.amazonaws.services.timestreamquery.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.CancelQueryRequestProtocolMarshaller;
import com.amazonaws.services.timestreamquery.model.transform.CancelQueryResultJsonUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.CreateScheduledQueryRequestProtocolMarshaller;
import com.amazonaws.services.timestreamquery.model.transform.CreateScheduledQueryResultJsonUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.DeleteScheduledQueryRequestProtocolMarshaller;
import com.amazonaws.services.timestreamquery.model.transform.DeleteScheduledQueryResultJsonUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.DescribeAccountSettingsRequestProtocolMarshaller;
import com.amazonaws.services.timestreamquery.model.transform.DescribeAccountSettingsResultJsonUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.DescribeEndpointsRequestProtocolMarshaller;
import com.amazonaws.services.timestreamquery.model.transform.DescribeEndpointsResultJsonUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.DescribeScheduledQueryRequestProtocolMarshaller;
import com.amazonaws.services.timestreamquery.model.transform.DescribeScheduledQueryResultJsonUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.ExecuteScheduledQueryRequestProtocolMarshaller;
import com.amazonaws.services.timestreamquery.model.transform.ExecuteScheduledQueryResultJsonUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.InvalidEndpointExceptionUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.ListScheduledQueriesRequestProtocolMarshaller;
import com.amazonaws.services.timestreamquery.model.transform.ListScheduledQueriesResultJsonUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.timestreamquery.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.PrepareQueryRequestProtocolMarshaller;
import com.amazonaws.services.timestreamquery.model.transform.PrepareQueryResultJsonUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.QueryExecutionExceptionUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.QueryRequestProtocolMarshaller;
import com.amazonaws.services.timestreamquery.model.transform.QueryResultJsonUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.timestreamquery.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.timestreamquery.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.UpdateAccountSettingsRequestProtocolMarshaller;
import com.amazonaws.services.timestreamquery.model.transform.UpdateAccountSettingsResultJsonUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.UpdateScheduledQueryRequestProtocolMarshaller;
import com.amazonaws.services.timestreamquery.model.transform.UpdateScheduledQueryResultJsonUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonTimestreamQueryClient
extends AmazonWebServiceClient
implements AmazonTimestreamQuery {
    protected AmazonTimestreamQueryEndpointCache cache;
    private final boolean endpointDiscoveryEnabled;
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonTimestreamQuery.class);
    private static final String DEFAULT_SIGNING_NAME = "timestream";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidEndpointException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidEndpointExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("QueryExecutionException").withExceptionUnmarshaller((JsonErrorUnmarshaller)QueryExecutionExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonTimestreamQueryException.class));

    public static AmazonTimestreamQueryClientBuilder builder() {
        return AmazonTimestreamQueryClientBuilder.standard();
    }

    AmazonTimestreamQueryClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonTimestreamQueryClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.endpointDiscoveryEnabled = endpointDiscoveryEnabled;
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        if (this.endpointDiscoveryEnabled) {
            this.cache = new AmazonTimestreamQueryEndpointCache(this);
        }
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("query.timestream");
        this.setEndpoint("query.timestream.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/timestreamquery/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/timestreamquery/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CancelQueryResult cancelQuery(CancelQueryRequest request) {
        request = (CancelQueryRequest)this.beforeClientExecution(request);
        return this.executeCancelQuery(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelQueryResult executeCancelQuery(CancelQueryRequest cancelQueryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelQueryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelQueryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelQueryRequestProtocolMarshaller(protocolFactory).marshall((CancelQueryRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelQueryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelQuery");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelQueryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            CancelQueryResult cancelQueryResult = (CancelQueryResult)response.getAwsResponse();
            return cancelQueryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateScheduledQueryResult createScheduledQuery(CreateScheduledQueryRequest request) {
        request = (CreateScheduledQueryRequest)this.beforeClientExecution(request);
        return this.executeCreateScheduledQuery(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateScheduledQueryResult executeCreateScheduledQuery(CreateScheduledQueryRequest createScheduledQueryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createScheduledQueryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateScheduledQueryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateScheduledQueryRequestProtocolMarshaller(protocolFactory).marshall((CreateScheduledQueryRequest)super.beforeMarshalling((AmazonWebServiceRequest)createScheduledQueryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateScheduledQuery");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateScheduledQueryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            CreateScheduledQueryResult createScheduledQueryResult = (CreateScheduledQueryResult)response.getAwsResponse();
            return createScheduledQueryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteScheduledQueryResult deleteScheduledQuery(DeleteScheduledQueryRequest request) {
        request = (DeleteScheduledQueryRequest)this.beforeClientExecution(request);
        return this.executeDeleteScheduledQuery(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteScheduledQueryResult executeDeleteScheduledQuery(DeleteScheduledQueryRequest deleteScheduledQueryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteScheduledQueryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteScheduledQueryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteScheduledQueryRequestProtocolMarshaller(protocolFactory).marshall((DeleteScheduledQueryRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteScheduledQueryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteScheduledQuery");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteScheduledQueryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            DeleteScheduledQueryResult deleteScheduledQueryResult = (DeleteScheduledQueryResult)response.getAwsResponse();
            return deleteScheduledQueryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAccountSettingsResult describeAccountSettings(DescribeAccountSettingsRequest request) {
        request = (DescribeAccountSettingsRequest)this.beforeClientExecution(request);
        return this.executeDescribeAccountSettings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAccountSettingsResult executeDescribeAccountSettings(DescribeAccountSettingsRequest describeAccountSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAccountSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAccountSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAccountSettingsRequestProtocolMarshaller(protocolFactory).marshall((DescribeAccountSettingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAccountSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAccountSettings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAccountSettingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            DescribeAccountSettingsResult describeAccountSettingsResult = (DescribeAccountSettingsResult)response.getAwsResponse();
            return describeAccountSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEndpointsResult describeEndpoints(DescribeEndpointsRequest request) {
        request = (DescribeEndpointsRequest)this.beforeClientExecution(request);
        return this.executeDescribeEndpoints(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEndpointsResult executeDescribeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEndpointsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEndpointsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEndpointsRequestProtocolMarshaller(protocolFactory).marshall((DescribeEndpointsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEndpointsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEndpoints");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEndpointsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEndpointsResult describeEndpointsResult = (DescribeEndpointsResult)response.getAwsResponse();
            return describeEndpointsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeScheduledQueryResult describeScheduledQuery(DescribeScheduledQueryRequest request) {
        request = (DescribeScheduledQueryRequest)this.beforeClientExecution(request);
        return this.executeDescribeScheduledQuery(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeScheduledQueryResult executeDescribeScheduledQuery(DescribeScheduledQueryRequest describeScheduledQueryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeScheduledQueryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeScheduledQueryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeScheduledQueryRequestProtocolMarshaller(protocolFactory).marshall((DescribeScheduledQueryRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeScheduledQueryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeScheduledQuery");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeScheduledQueryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            DescribeScheduledQueryResult describeScheduledQueryResult = (DescribeScheduledQueryResult)response.getAwsResponse();
            return describeScheduledQueryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExecuteScheduledQueryResult executeScheduledQuery(ExecuteScheduledQueryRequest request) {
        request = (ExecuteScheduledQueryRequest)this.beforeClientExecution(request);
        return this.executeExecuteScheduledQuery(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExecuteScheduledQueryResult executeExecuteScheduledQuery(ExecuteScheduledQueryRequest executeScheduledQueryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(executeScheduledQueryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExecuteScheduledQueryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExecuteScheduledQueryRequestProtocolMarshaller(protocolFactory).marshall((ExecuteScheduledQueryRequest)super.beforeMarshalling((AmazonWebServiceRequest)executeScheduledQueryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ExecuteScheduledQuery");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ExecuteScheduledQueryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            ExecuteScheduledQueryResult executeScheduledQueryResult = (ExecuteScheduledQueryResult)response.getAwsResponse();
            return executeScheduledQueryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListScheduledQueriesResult listScheduledQueries(ListScheduledQueriesRequest request) {
        request = (ListScheduledQueriesRequest)this.beforeClientExecution(request);
        return this.executeListScheduledQueries(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListScheduledQueriesResult executeListScheduledQueries(ListScheduledQueriesRequest listScheduledQueriesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listScheduledQueriesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListScheduledQueriesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListScheduledQueriesRequestProtocolMarshaller(protocolFactory).marshall((ListScheduledQueriesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listScheduledQueriesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListScheduledQueries");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListScheduledQueriesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            ListScheduledQueriesResult listScheduledQueriesResult = (ListScheduledQueriesResult)response.getAwsResponse();
            return listScheduledQueriesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PrepareQueryResult prepareQuery(PrepareQueryRequest request) {
        request = (PrepareQueryRequest)this.beforeClientExecution(request);
        return this.executePrepareQuery(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PrepareQueryResult executePrepareQuery(PrepareQueryRequest prepareQueryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(prepareQueryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PrepareQueryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PrepareQueryRequestProtocolMarshaller(protocolFactory).marshall((PrepareQueryRequest)super.beforeMarshalling((AmazonWebServiceRequest)prepareQueryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PrepareQuery");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PrepareQueryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            PrepareQueryResult prepareQueryResult = (PrepareQueryResult)response.getAwsResponse();
            return prepareQueryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public QueryResult query(QueryRequest request) {
        request = (QueryRequest)this.beforeClientExecution(request);
        return this.executeQuery(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final QueryResult executeQuery(QueryRequest queryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(queryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<QueryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new QueryRequestProtocolMarshaller(protocolFactory).marshall((QueryRequest)super.beforeMarshalling((AmazonWebServiceRequest)queryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"Query");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new QueryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            QueryResult queryResult = (QueryResult)response.getAwsResponse();
            return queryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateAccountSettingsResult updateAccountSettings(UpdateAccountSettingsRequest request) {
        request = (UpdateAccountSettingsRequest)this.beforeClientExecution(request);
        return this.executeUpdateAccountSettings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateAccountSettingsResult executeUpdateAccountSettings(UpdateAccountSettingsRequest updateAccountSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAccountSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAccountSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAccountSettingsRequestProtocolMarshaller(protocolFactory).marshall((UpdateAccountSettingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAccountSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateAccountSettings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateAccountSettingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            UpdateAccountSettingsResult updateAccountSettingsResult = (UpdateAccountSettingsResult)response.getAwsResponse();
            return updateAccountSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateScheduledQueryResult updateScheduledQuery(UpdateScheduledQueryRequest request) {
        request = (UpdateScheduledQueryRequest)this.beforeClientExecution(request);
        return this.executeUpdateScheduledQuery(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateScheduledQueryResult executeUpdateScheduledQuery(UpdateScheduledQueryRequest updateScheduledQueryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateScheduledQueryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateScheduledQueryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateScheduledQueryRequestProtocolMarshaller(protocolFactory).marshall((UpdateScheduledQueryRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateScheduledQueryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream Query");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateScheduledQuery");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI cachedEndpoint = null;
            if (this.endpointDiscoveryEnabled) {
                DescribeEndpointsRequest discoveryRequest = new DescribeEndpointsRequest();
                cachedEndpoint = this.cache.get(this.awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (AmazonWebServiceRequest)discoveryRequest, true, this.endpoint);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateScheduledQueryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, cachedEndpoint, null);
            UpdateScheduledQueryResult updateScheduledQueryResult = (UpdateScheduledQueryResult)response.getAwsResponse();
            return updateScheduledQueryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.cache != null) {
            this.cache.shutdown();
        }
    }
}

