/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamquery.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.timestreamquery.model.Type;
import java.util.List;

@SdkInternalApi
public class TypeMarshaller {
    private static final MarshallingInfo<String> SCALARTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScalarType").build();
    private static final MarshallingInfo<StructuredPojo> ARRAYCOLUMNINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArrayColumnInfo").build();
    private static final MarshallingInfo<StructuredPojo> TIMESERIESMEASUREVALUECOLUMNINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeSeriesMeasureValueColumnInfo").build();
    private static final MarshallingInfo<List> ROWCOLUMNINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RowColumnInfo").build();
    private static final TypeMarshaller instance = new TypeMarshaller();

    public static TypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(Type type, ProtocolMarshaller protocolMarshaller) {
        if (type == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)type.getScalarType(), SCALARTYPE_BINDING);
            protocolMarshaller.marshall((Object)type.getArrayColumnInfo(), ARRAYCOLUMNINFO_BINDING);
            protocolMarshaller.marshall((Object)type.getTimeSeriesMeasureValueColumnInfo(), TIMESERIESMEASUREVALUECOLUMNINFO_BINDING);
            protocolMarshaller.marshall(type.getRowColumnInfo(), ROWCOLUMNINFO_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

