/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.ExpenseField;
import java.util.List;

@SdkInternalApi
public class ExpenseFieldMarshaller {
    private static final MarshallingInfo<StructuredPojo> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<StructuredPojo> LABELDETECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LabelDetection").build();
    private static final MarshallingInfo<StructuredPojo> VALUEDETECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValueDetection").build();
    private static final MarshallingInfo<Integer> PAGENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageNumber").build();
    private static final MarshallingInfo<StructuredPojo> CURRENCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Currency").build();
    private static final MarshallingInfo<List> GROUPPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GroupProperties").build();
    private static final ExpenseFieldMarshaller instance = new ExpenseFieldMarshaller();

    public static ExpenseFieldMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExpenseField expenseField, ProtocolMarshaller protocolMarshaller) {
        if (expenseField == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)expenseField.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)expenseField.getLabelDetection(), LABELDETECTION_BINDING);
            protocolMarshaller.marshall((Object)expenseField.getValueDetection(), VALUEDETECTION_BINDING);
            protocolMarshaller.marshall((Object)expenseField.getPageNumber(), PAGENUMBER_BINDING);
            protocolMarshaller.marshall((Object)expenseField.getCurrency(), CURRENCY_BINDING);
            protocolMarshaller.marshall(expenseField.getGroupProperties(), GROUPPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

