/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.sqs.model.StartMessageMoveTaskRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class StartMessageMoveTaskRequestMarshaller
implements Marshaller<Request<StartMessageMoveTaskRequest>, StartMessageMoveTaskRequest> {
    public Request<StartMessageMoveTaskRequest> marshall(StartMessageMoveTaskRequest startMessageMoveTaskRequest) {
        if (startMessageMoveTaskRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)startMessageMoveTaskRequest, "AmazonSQS");
        request.addParameter("Action", "StartMessageMoveTask");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (startMessageMoveTaskRequest.getSourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString((String)startMessageMoveTaskRequest.getSourceArn()));
        }
        if (startMessageMoveTaskRequest.getDestinationArn() != null) {
            request.addParameter("DestinationArn", StringUtils.fromString((String)startMessageMoveTaskRequest.getDestinationArn()));
        }
        if (startMessageMoveTaskRequest.getMaxNumberOfMessagesPerSecond() != null) {
            request.addParameter("MaxNumberOfMessagesPerSecond", StringUtils.fromInteger((Integer)startMessageMoveTaskRequest.getMaxNumberOfMessagesPerSecond()));
        }
        return request;
    }
}

