/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.servicecatalog.model.CopyOption;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CopyProductRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String acceptLanguage;
    private String sourceProductArn;
    private String targetProductId;
    private String targetProductName;
    private List<Map<String, String>> sourceProvisioningArtifactIdentifiers;
    private List<String> copyOptions;
    private String idempotencyToken;

    public void setAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public CopyProductRequest withAcceptLanguage(String acceptLanguage) {
        this.setAcceptLanguage(acceptLanguage);
        return this;
    }

    public void setSourceProductArn(String sourceProductArn) {
        this.sourceProductArn = sourceProductArn;
    }

    public String getSourceProductArn() {
        return this.sourceProductArn;
    }

    public CopyProductRequest withSourceProductArn(String sourceProductArn) {
        this.setSourceProductArn(sourceProductArn);
        return this;
    }

    public void setTargetProductId(String targetProductId) {
        this.targetProductId = targetProductId;
    }

    public String getTargetProductId() {
        return this.targetProductId;
    }

    public CopyProductRequest withTargetProductId(String targetProductId) {
        this.setTargetProductId(targetProductId);
        return this;
    }

    public void setTargetProductName(String targetProductName) {
        this.targetProductName = targetProductName;
    }

    public String getTargetProductName() {
        return this.targetProductName;
    }

    public CopyProductRequest withTargetProductName(String targetProductName) {
        this.setTargetProductName(targetProductName);
        return this;
    }

    public List<Map<String, String>> getSourceProvisioningArtifactIdentifiers() {
        return this.sourceProvisioningArtifactIdentifiers;
    }

    public void setSourceProvisioningArtifactIdentifiers(Collection<Map<String, String>> sourceProvisioningArtifactIdentifiers) {
        if (sourceProvisioningArtifactIdentifiers == null) {
            this.sourceProvisioningArtifactIdentifiers = null;
            return;
        }
        this.sourceProvisioningArtifactIdentifiers = new ArrayList<Map<String, String>>(sourceProvisioningArtifactIdentifiers);
    }

    public CopyProductRequest withSourceProvisioningArtifactIdentifiers(Map<String, String> ... sourceProvisioningArtifactIdentifiers) {
        if (this.sourceProvisioningArtifactIdentifiers == null) {
            this.setSourceProvisioningArtifactIdentifiers(new ArrayList<Map<String, String>>(sourceProvisioningArtifactIdentifiers.length));
        }
        for (Map<String, String> ele : sourceProvisioningArtifactIdentifiers) {
            this.sourceProvisioningArtifactIdentifiers.add(ele);
        }
        return this;
    }

    public CopyProductRequest withSourceProvisioningArtifactIdentifiers(Collection<Map<String, String>> sourceProvisioningArtifactIdentifiers) {
        this.setSourceProvisioningArtifactIdentifiers(sourceProvisioningArtifactIdentifiers);
        return this;
    }

    public List<String> getCopyOptions() {
        return this.copyOptions;
    }

    public void setCopyOptions(Collection<String> copyOptions) {
        if (copyOptions == null) {
            this.copyOptions = null;
            return;
        }
        this.copyOptions = new ArrayList<String>(copyOptions);
    }

    public CopyProductRequest withCopyOptions(String ... copyOptions) {
        if (this.copyOptions == null) {
            this.setCopyOptions(new ArrayList<String>(copyOptions.length));
        }
        for (String ele : copyOptions) {
            this.copyOptions.add(ele);
        }
        return this;
    }

    public CopyProductRequest withCopyOptions(Collection<String> copyOptions) {
        this.setCopyOptions(copyOptions);
        return this;
    }

    public CopyProductRequest withCopyOptions(CopyOption ... copyOptions) {
        ArrayList<String> copyOptionsCopy = new ArrayList<String>(copyOptions.length);
        for (CopyOption value : copyOptions) {
            copyOptionsCopy.add(value.toString());
        }
        if (this.getCopyOptions() == null) {
            this.setCopyOptions(copyOptionsCopy);
        } else {
            this.getCopyOptions().addAll(copyOptionsCopy);
        }
        return this;
    }

    public void setIdempotencyToken(String idempotencyToken) {
        this.idempotencyToken = idempotencyToken;
    }

    public String getIdempotencyToken() {
        return this.idempotencyToken;
    }

    public CopyProductRequest withIdempotencyToken(String idempotencyToken) {
        this.setIdempotencyToken(idempotencyToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAcceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.getAcceptLanguage()).append(",");
        }
        if (this.getSourceProductArn() != null) {
            sb.append("SourceProductArn: ").append(this.getSourceProductArn()).append(",");
        }
        if (this.getTargetProductId() != null) {
            sb.append("TargetProductId: ").append(this.getTargetProductId()).append(",");
        }
        if (this.getTargetProductName() != null) {
            sb.append("TargetProductName: ").append(this.getTargetProductName()).append(",");
        }
        if (this.getSourceProvisioningArtifactIdentifiers() != null) {
            sb.append("SourceProvisioningArtifactIdentifiers: ").append(this.getSourceProvisioningArtifactIdentifiers()).append(",");
        }
        if (this.getCopyOptions() != null) {
            sb.append("CopyOptions: ").append(this.getCopyOptions()).append(",");
        }
        if (this.getIdempotencyToken() != null) {
            sb.append("IdempotencyToken: ").append(this.getIdempotencyToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyProductRequest)) {
            return false;
        }
        CopyProductRequest other = (CopyProductRequest)obj;
        if (other.getAcceptLanguage() == null ^ this.getAcceptLanguage() == null) {
            return false;
        }
        if (other.getAcceptLanguage() != null && !other.getAcceptLanguage().equals(this.getAcceptLanguage())) {
            return false;
        }
        if (other.getSourceProductArn() == null ^ this.getSourceProductArn() == null) {
            return false;
        }
        if (other.getSourceProductArn() != null && !other.getSourceProductArn().equals(this.getSourceProductArn())) {
            return false;
        }
        if (other.getTargetProductId() == null ^ this.getTargetProductId() == null) {
            return false;
        }
        if (other.getTargetProductId() != null && !other.getTargetProductId().equals(this.getTargetProductId())) {
            return false;
        }
        if (other.getTargetProductName() == null ^ this.getTargetProductName() == null) {
            return false;
        }
        if (other.getTargetProductName() != null && !other.getTargetProductName().equals(this.getTargetProductName())) {
            return false;
        }
        if (other.getSourceProvisioningArtifactIdentifiers() == null ^ this.getSourceProvisioningArtifactIdentifiers() == null) {
            return false;
        }
        if (other.getSourceProvisioningArtifactIdentifiers() != null && !other.getSourceProvisioningArtifactIdentifiers().equals(this.getSourceProvisioningArtifactIdentifiers())) {
            return false;
        }
        if (other.getCopyOptions() == null ^ this.getCopyOptions() == null) {
            return false;
        }
        if (other.getCopyOptions() != null && !other.getCopyOptions().equals(this.getCopyOptions())) {
            return false;
        }
        if (other.getIdempotencyToken() == null ^ this.getIdempotencyToken() == null) {
            return false;
        }
        return other.getIdempotencyToken() == null || other.getIdempotencyToken().equals(this.getIdempotencyToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAcceptLanguage() == null ? 0 : this.getAcceptLanguage().hashCode());
        hashCode = 31 * hashCode + (this.getSourceProductArn() == null ? 0 : this.getSourceProductArn().hashCode());
        hashCode = 31 * hashCode + (this.getTargetProductId() == null ? 0 : this.getTargetProductId().hashCode());
        hashCode = 31 * hashCode + (this.getTargetProductName() == null ? 0 : this.getTargetProductName().hashCode());
        hashCode = 31 * hashCode + (this.getSourceProvisioningArtifactIdentifiers() == null ? 0 : this.getSourceProvisioningArtifactIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.getCopyOptions() == null ? 0 : this.getCopyOptions().hashCode());
        hashCode = 31 * hashCode + (this.getIdempotencyToken() == null ? 0 : this.getIdempotencyToken().hashCode());
        return hashCode;
    }

    public CopyProductRequest clone() {
        return (CopyProductRequest)super.clone();
    }
}

