/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53profiles;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.route53profiles.AWSRoute53Profiles;
import com.amazonaws.services.route53profiles.AWSRoute53ProfilesClientBuilder;
import com.amazonaws.services.route53profiles.model.AWSRoute53ProfilesException;
import com.amazonaws.services.route53profiles.model.AssociateProfileRequest;
import com.amazonaws.services.route53profiles.model.AssociateProfileResult;
import com.amazonaws.services.route53profiles.model.AssociateResourceToProfileRequest;
import com.amazonaws.services.route53profiles.model.AssociateResourceToProfileResult;
import com.amazonaws.services.route53profiles.model.CreateProfileRequest;
import com.amazonaws.services.route53profiles.model.CreateProfileResult;
import com.amazonaws.services.route53profiles.model.DeleteProfileRequest;
import com.amazonaws.services.route53profiles.model.DeleteProfileResult;
import com.amazonaws.services.route53profiles.model.DisassociateProfileRequest;
import com.amazonaws.services.route53profiles.model.DisassociateProfileResult;
import com.amazonaws.services.route53profiles.model.DisassociateResourceFromProfileRequest;
import com.amazonaws.services.route53profiles.model.DisassociateResourceFromProfileResult;
import com.amazonaws.services.route53profiles.model.GetProfileAssociationRequest;
import com.amazonaws.services.route53profiles.model.GetProfileAssociationResult;
import com.amazonaws.services.route53profiles.model.GetProfileRequest;
import com.amazonaws.services.route53profiles.model.GetProfileResourceAssociationRequest;
import com.amazonaws.services.route53profiles.model.GetProfileResourceAssociationResult;
import com.amazonaws.services.route53profiles.model.GetProfileResult;
import com.amazonaws.services.route53profiles.model.ListProfileAssociationsRequest;
import com.amazonaws.services.route53profiles.model.ListProfileAssociationsResult;
import com.amazonaws.services.route53profiles.model.ListProfileResourceAssociationsRequest;
import com.amazonaws.services.route53profiles.model.ListProfileResourceAssociationsResult;
import com.amazonaws.services.route53profiles.model.ListProfilesRequest;
import com.amazonaws.services.route53profiles.model.ListProfilesResult;
import com.amazonaws.services.route53profiles.model.ListTagsForResourceRequest;
import com.amazonaws.services.route53profiles.model.ListTagsForResourceResult;
import com.amazonaws.services.route53profiles.model.TagResourceRequest;
import com.amazonaws.services.route53profiles.model.TagResourceResult;
import com.amazonaws.services.route53profiles.model.UntagResourceRequest;
import com.amazonaws.services.route53profiles.model.UntagResourceResult;
import com.amazonaws.services.route53profiles.model.UpdateProfileResourceAssociationRequest;
import com.amazonaws.services.route53profiles.model.UpdateProfileResourceAssociationResult;
import com.amazonaws.services.route53profiles.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.AssociateProfileRequestProtocolMarshaller;
import com.amazonaws.services.route53profiles.model.transform.AssociateProfileResultJsonUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.AssociateResourceToProfileRequestProtocolMarshaller;
import com.amazonaws.services.route53profiles.model.transform.AssociateResourceToProfileResultJsonUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.CreateProfileRequestProtocolMarshaller;
import com.amazonaws.services.route53profiles.model.transform.CreateProfileResultJsonUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.DeleteProfileRequestProtocolMarshaller;
import com.amazonaws.services.route53profiles.model.transform.DeleteProfileResultJsonUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.DisassociateProfileRequestProtocolMarshaller;
import com.amazonaws.services.route53profiles.model.transform.DisassociateProfileResultJsonUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.DisassociateResourceFromProfileRequestProtocolMarshaller;
import com.amazonaws.services.route53profiles.model.transform.DisassociateResourceFromProfileResultJsonUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.GetProfileAssociationRequestProtocolMarshaller;
import com.amazonaws.services.route53profiles.model.transform.GetProfileAssociationResultJsonUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.GetProfileRequestProtocolMarshaller;
import com.amazonaws.services.route53profiles.model.transform.GetProfileResourceAssociationRequestProtocolMarshaller;
import com.amazonaws.services.route53profiles.model.transform.GetProfileResourceAssociationResultJsonUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.GetProfileResultJsonUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.InternalServiceErrorExceptionUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.ListProfileAssociationsRequestProtocolMarshaller;
import com.amazonaws.services.route53profiles.model.transform.ListProfileAssociationsResultJsonUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.ListProfileResourceAssociationsRequestProtocolMarshaller;
import com.amazonaws.services.route53profiles.model.transform.ListProfileResourceAssociationsResultJsonUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.ListProfilesRequestProtocolMarshaller;
import com.amazonaws.services.route53profiles.model.transform.ListProfilesResultJsonUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.route53profiles.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.ResourceExistsExceptionUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.route53profiles.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.route53profiles.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.UpdateProfileResourceAssociationRequestProtocolMarshaller;
import com.amazonaws.services.route53profiles.model.transform.UpdateProfileResourceAssociationResultJsonUnmarshaller;
import com.amazonaws.services.route53profiles.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSRoute53ProfilesClient
extends AmazonWebServiceClient
implements AWSRoute53Profiles {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSRoute53Profiles.class);
    private static final String DEFAULT_SIGNING_NAME = "route53profiles";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidParameterExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServiceErrorException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServiceErrorExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceExistsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidNextTokenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSRoute53ProfilesException.class));

    public static AWSRoute53ProfilesClientBuilder builder() {
        return AWSRoute53ProfilesClientBuilder.standard();
    }

    AWSRoute53ProfilesClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSRoute53ProfilesClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("route53profiles.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/route53profiles/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/route53profiles/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateProfileResult associateProfile(AssociateProfileRequest request) {
        request = (AssociateProfileRequest)this.beforeClientExecution(request);
        return this.executeAssociateProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateProfileResult executeAssociateProfile(AssociateProfileRequest associateProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateProfileRequestProtocolMarshaller(protocolFactory).marshall((AssociateProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Route53Profiles");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateProfileResult associateProfileResult = (AssociateProfileResult)response.getAwsResponse();
            return associateProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AssociateResourceToProfileResult associateResourceToProfile(AssociateResourceToProfileRequest request) {
        request = (AssociateResourceToProfileRequest)this.beforeClientExecution(request);
        return this.executeAssociateResourceToProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateResourceToProfileResult executeAssociateResourceToProfile(AssociateResourceToProfileRequest associateResourceToProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateResourceToProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateResourceToProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateResourceToProfileRequestProtocolMarshaller(protocolFactory).marshall((AssociateResourceToProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateResourceToProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Route53Profiles");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateResourceToProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateResourceToProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateResourceToProfileResult associateResourceToProfileResult = (AssociateResourceToProfileResult)response.getAwsResponse();
            return associateResourceToProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateProfileResult createProfile(CreateProfileRequest request) {
        request = (CreateProfileRequest)this.beforeClientExecution(request);
        return this.executeCreateProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateProfileResult executeCreateProfile(CreateProfileRequest createProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateProfileRequestProtocolMarshaller(protocolFactory).marshall((CreateProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)createProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Route53Profiles");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateProfileResult createProfileResult = (CreateProfileResult)response.getAwsResponse();
            return createProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteProfileResult deleteProfile(DeleteProfileRequest request) {
        request = (DeleteProfileRequest)this.beforeClientExecution(request);
        return this.executeDeleteProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteProfileResult executeDeleteProfile(DeleteProfileRequest deleteProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteProfileRequestProtocolMarshaller(protocolFactory).marshall((DeleteProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Route53Profiles");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteProfileResult deleteProfileResult = (DeleteProfileResult)response.getAwsResponse();
            return deleteProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateProfileResult disassociateProfile(DisassociateProfileRequest request) {
        request = (DisassociateProfileRequest)this.beforeClientExecution(request);
        return this.executeDisassociateProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateProfileResult executeDisassociateProfile(DisassociateProfileRequest disassociateProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateProfileRequestProtocolMarshaller(protocolFactory).marshall((DisassociateProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Route53Profiles");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateProfileResult disassociateProfileResult = (DisassociateProfileResult)response.getAwsResponse();
            return disassociateProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateResourceFromProfileResult disassociateResourceFromProfile(DisassociateResourceFromProfileRequest request) {
        request = (DisassociateResourceFromProfileRequest)this.beforeClientExecution(request);
        return this.executeDisassociateResourceFromProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateResourceFromProfileResult executeDisassociateResourceFromProfile(DisassociateResourceFromProfileRequest disassociateResourceFromProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateResourceFromProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateResourceFromProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateResourceFromProfileRequestProtocolMarshaller(protocolFactory).marshall((DisassociateResourceFromProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateResourceFromProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Route53Profiles");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateResourceFromProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateResourceFromProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateResourceFromProfileResult disassociateResourceFromProfileResult = (DisassociateResourceFromProfileResult)response.getAwsResponse();
            return disassociateResourceFromProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetProfileResult getProfile(GetProfileRequest request) {
        request = (GetProfileRequest)this.beforeClientExecution(request);
        return this.executeGetProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetProfileResult executeGetProfile(GetProfileRequest getProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetProfileRequestProtocolMarshaller(protocolFactory).marshall((GetProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)getProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Route53Profiles");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetProfileResult getProfileResult = (GetProfileResult)response.getAwsResponse();
            return getProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetProfileAssociationResult getProfileAssociation(GetProfileAssociationRequest request) {
        request = (GetProfileAssociationRequest)this.beforeClientExecution(request);
        return this.executeGetProfileAssociation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetProfileAssociationResult executeGetProfileAssociation(GetProfileAssociationRequest getProfileAssociationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getProfileAssociationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetProfileAssociationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetProfileAssociationRequestProtocolMarshaller(protocolFactory).marshall((GetProfileAssociationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getProfileAssociationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Route53Profiles");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetProfileAssociation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetProfileAssociationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetProfileAssociationResult getProfileAssociationResult = (GetProfileAssociationResult)response.getAwsResponse();
            return getProfileAssociationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetProfileResourceAssociationResult getProfileResourceAssociation(GetProfileResourceAssociationRequest request) {
        request = (GetProfileResourceAssociationRequest)this.beforeClientExecution(request);
        return this.executeGetProfileResourceAssociation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetProfileResourceAssociationResult executeGetProfileResourceAssociation(GetProfileResourceAssociationRequest getProfileResourceAssociationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getProfileResourceAssociationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetProfileResourceAssociationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetProfileResourceAssociationRequestProtocolMarshaller(protocolFactory).marshall((GetProfileResourceAssociationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getProfileResourceAssociationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Route53Profiles");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetProfileResourceAssociation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetProfileResourceAssociationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetProfileResourceAssociationResult getProfileResourceAssociationResult = (GetProfileResourceAssociationResult)response.getAwsResponse();
            return getProfileResourceAssociationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListProfileAssociationsResult listProfileAssociations(ListProfileAssociationsRequest request) {
        request = (ListProfileAssociationsRequest)this.beforeClientExecution(request);
        return this.executeListProfileAssociations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListProfileAssociationsResult executeListProfileAssociations(ListProfileAssociationsRequest listProfileAssociationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProfileAssociationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProfileAssociationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProfileAssociationsRequestProtocolMarshaller(protocolFactory).marshall((ListProfileAssociationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listProfileAssociationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Route53Profiles");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListProfileAssociations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListProfileAssociationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProfileAssociationsResult listProfileAssociationsResult = (ListProfileAssociationsResult)response.getAwsResponse();
            return listProfileAssociationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListProfileResourceAssociationsResult listProfileResourceAssociations(ListProfileResourceAssociationsRequest request) {
        request = (ListProfileResourceAssociationsRequest)this.beforeClientExecution(request);
        return this.executeListProfileResourceAssociations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListProfileResourceAssociationsResult executeListProfileResourceAssociations(ListProfileResourceAssociationsRequest listProfileResourceAssociationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProfileResourceAssociationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProfileResourceAssociationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProfileResourceAssociationsRequestProtocolMarshaller(protocolFactory).marshall((ListProfileResourceAssociationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listProfileResourceAssociationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Route53Profiles");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListProfileResourceAssociations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListProfileResourceAssociationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProfileResourceAssociationsResult listProfileResourceAssociationsResult = (ListProfileResourceAssociationsResult)response.getAwsResponse();
            return listProfileResourceAssociationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListProfilesResult listProfiles(ListProfilesRequest request) {
        request = (ListProfilesRequest)this.beforeClientExecution(request);
        return this.executeListProfiles(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListProfilesResult executeListProfiles(ListProfilesRequest listProfilesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProfilesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProfilesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProfilesRequestProtocolMarshaller(protocolFactory).marshall((ListProfilesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listProfilesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Route53Profiles");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListProfiles");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListProfilesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProfilesResult listProfilesResult = (ListProfilesResult)response.getAwsResponse();
            return listProfilesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Route53Profiles");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Route53Profiles");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Route53Profiles");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateProfileResourceAssociationResult updateProfileResourceAssociation(UpdateProfileResourceAssociationRequest request) {
        request = (UpdateProfileResourceAssociationRequest)this.beforeClientExecution(request);
        return this.executeUpdateProfileResourceAssociation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateProfileResourceAssociationResult executeUpdateProfileResourceAssociation(UpdateProfileResourceAssociationRequest updateProfileResourceAssociationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateProfileResourceAssociationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateProfileResourceAssociationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateProfileResourceAssociationRequestProtocolMarshaller(protocolFactory).marshall((UpdateProfileResourceAssociationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateProfileResourceAssociationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Route53Profiles");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateProfileResourceAssociation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateProfileResourceAssociationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateProfileResourceAssociationResult updateProfileResourceAssociationResult = (UpdateProfileResourceAssociationResult)response.getAwsResponse();
            return updateProfileResourceAssociationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

