/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.ContributionAnalysisDirection;
import com.amazonaws.services.quicksight.model.ContributionAnalysisFactor;
import com.amazonaws.services.quicksight.model.ContributionAnalysisSortType;
import com.amazonaws.services.quicksight.model.ContributionAnalysisTimeRanges;
import com.amazonaws.services.quicksight.model.transform.TopicIRContributionAnalysisMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TopicIRContributionAnalysis
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ContributionAnalysisFactor> factors;
    private ContributionAnalysisTimeRanges timeRanges;
    private String direction;
    private String sortType;

    public List<ContributionAnalysisFactor> getFactors() {
        return this.factors;
    }

    public void setFactors(Collection<ContributionAnalysisFactor> factors) {
        if (factors == null) {
            this.factors = null;
            return;
        }
        this.factors = new ArrayList<ContributionAnalysisFactor>(factors);
    }

    public TopicIRContributionAnalysis withFactors(ContributionAnalysisFactor ... factors) {
        if (this.factors == null) {
            this.setFactors(new ArrayList<ContributionAnalysisFactor>(factors.length));
        }
        for (ContributionAnalysisFactor ele : factors) {
            this.factors.add(ele);
        }
        return this;
    }

    public TopicIRContributionAnalysis withFactors(Collection<ContributionAnalysisFactor> factors) {
        this.setFactors(factors);
        return this;
    }

    public void setTimeRanges(ContributionAnalysisTimeRanges timeRanges) {
        this.timeRanges = timeRanges;
    }

    public ContributionAnalysisTimeRanges getTimeRanges() {
        return this.timeRanges;
    }

    public TopicIRContributionAnalysis withTimeRanges(ContributionAnalysisTimeRanges timeRanges) {
        this.setTimeRanges(timeRanges);
        return this;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getDirection() {
        return this.direction;
    }

    public TopicIRContributionAnalysis withDirection(String direction) {
        this.setDirection(direction);
        return this;
    }

    public TopicIRContributionAnalysis withDirection(ContributionAnalysisDirection direction) {
        this.direction = direction.toString();
        return this;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getSortType() {
        return this.sortType;
    }

    public TopicIRContributionAnalysis withSortType(String sortType) {
        this.setSortType(sortType);
        return this;
    }

    public TopicIRContributionAnalysis withSortType(ContributionAnalysisSortType sortType) {
        this.sortType = sortType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFactors() != null) {
            sb.append("Factors: ").append(this.getFactors()).append(",");
        }
        if (this.getTimeRanges() != null) {
            sb.append("TimeRanges: ").append(this.getTimeRanges()).append(",");
        }
        if (this.getDirection() != null) {
            sb.append("Direction: ").append(this.getDirection()).append(",");
        }
        if (this.getSortType() != null) {
            sb.append("SortType: ").append(this.getSortType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicIRContributionAnalysis)) {
            return false;
        }
        TopicIRContributionAnalysis other = (TopicIRContributionAnalysis)obj;
        if (other.getFactors() == null ^ this.getFactors() == null) {
            return false;
        }
        if (other.getFactors() != null && !other.getFactors().equals(this.getFactors())) {
            return false;
        }
        if (other.getTimeRanges() == null ^ this.getTimeRanges() == null) {
            return false;
        }
        if (other.getTimeRanges() != null && !other.getTimeRanges().equals(this.getTimeRanges())) {
            return false;
        }
        if (other.getDirection() == null ^ this.getDirection() == null) {
            return false;
        }
        if (other.getDirection() != null && !other.getDirection().equals(this.getDirection())) {
            return false;
        }
        if (other.getSortType() == null ^ this.getSortType() == null) {
            return false;
        }
        return other.getSortType() == null || other.getSortType().equals(this.getSortType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFactors() == null ? 0 : this.getFactors().hashCode());
        hashCode = 31 * hashCode + (this.getTimeRanges() == null ? 0 : this.getTimeRanges().hashCode());
        hashCode = 31 * hashCode + (this.getDirection() == null ? 0 : this.getDirection().hashCode());
        hashCode = 31 * hashCode + (this.getSortType() == null ? 0 : this.getSortType().hashCode());
        return hashCode;
    }

    public TopicIRContributionAnalysis clone() {
        try {
            return (TopicIRContributionAnalysis)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopicIRContributionAnalysisMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

