/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconnect.model.Bridge;
import java.util.List;

@SdkInternalApi
public class BridgeMarshaller {
    private static final MarshallingInfo<String> BRIDGEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bridgeArn").build();
    private static final MarshallingInfo<List> BRIDGEMESSAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bridgeMessages").build();
    private static final MarshallingInfo<String> BRIDGESTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bridgeState").build();
    private static final MarshallingInfo<StructuredPojo> EGRESSGATEWAYBRIDGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("egressGatewayBridge").build();
    private static final MarshallingInfo<StructuredPojo> INGRESSGATEWAYBRIDGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ingressGatewayBridge").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<List> OUTPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputs").build();
    private static final MarshallingInfo<String> PLACEMENTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("placementArn").build();
    private static final MarshallingInfo<StructuredPojo> SOURCEFAILOVERCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceFailoverConfig").build();
    private static final MarshallingInfo<List> SOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sources").build();
    private static final BridgeMarshaller instance = new BridgeMarshaller();

    public static BridgeMarshaller getInstance() {
        return instance;
    }

    public void marshall(Bridge bridge, ProtocolMarshaller protocolMarshaller) {
        if (bridge == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)bridge.getBridgeArn(), BRIDGEARN_BINDING);
            protocolMarshaller.marshall(bridge.getBridgeMessages(), BRIDGEMESSAGES_BINDING);
            protocolMarshaller.marshall((Object)bridge.getBridgeState(), BRIDGESTATE_BINDING);
            protocolMarshaller.marshall((Object)bridge.getEgressGatewayBridge(), EGRESSGATEWAYBRIDGE_BINDING);
            protocolMarshaller.marshall((Object)bridge.getIngressGatewayBridge(), INGRESSGATEWAYBRIDGE_BINDING);
            protocolMarshaller.marshall((Object)bridge.getName(), NAME_BINDING);
            protocolMarshaller.marshall(bridge.getOutputs(), OUTPUTS_BINDING);
            protocolMarshaller.marshall((Object)bridge.getPlacementArn(), PLACEMENTARN_BINDING);
            protocolMarshaller.marshall((Object)bridge.getSourceFailoverConfig(), SOURCEFAILOVERCONFIG_BINDING);
            protocolMarshaller.marshall(bridge.getSources(), SOURCES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

