/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconnect.model.BridgePlacement;
import com.amazonaws.services.mediaconnect.model.ConnectionStatus;
import com.amazonaws.services.mediaconnect.model.InstanceState;
import com.amazonaws.services.mediaconnect.model.MessageDetail;
import com.amazonaws.services.mediaconnect.model.transform.GatewayInstanceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GatewayInstance
implements Serializable,
Cloneable,
StructuredPojo {
    private String bridgePlacement;
    private String connectionStatus;
    private String gatewayArn;
    private String gatewayInstanceArn;
    private String instanceId;
    private List<MessageDetail> instanceMessages;
    private String instanceState;
    private Integer runningBridgeCount;

    public void setBridgePlacement(String bridgePlacement) {
        this.bridgePlacement = bridgePlacement;
    }

    public String getBridgePlacement() {
        return this.bridgePlacement;
    }

    public GatewayInstance withBridgePlacement(String bridgePlacement) {
        this.setBridgePlacement(bridgePlacement);
        return this;
    }

    public GatewayInstance withBridgePlacement(BridgePlacement bridgePlacement) {
        this.bridgePlacement = bridgePlacement.toString();
        return this;
    }

    public void setConnectionStatus(String connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    public String getConnectionStatus() {
        return this.connectionStatus;
    }

    public GatewayInstance withConnectionStatus(String connectionStatus) {
        this.setConnectionStatus(connectionStatus);
        return this;
    }

    public GatewayInstance withConnectionStatus(ConnectionStatus connectionStatus) {
        this.connectionStatus = connectionStatus.toString();
        return this;
    }

    public void setGatewayArn(String gatewayArn) {
        this.gatewayArn = gatewayArn;
    }

    public String getGatewayArn() {
        return this.gatewayArn;
    }

    public GatewayInstance withGatewayArn(String gatewayArn) {
        this.setGatewayArn(gatewayArn);
        return this;
    }

    public void setGatewayInstanceArn(String gatewayInstanceArn) {
        this.gatewayInstanceArn = gatewayInstanceArn;
    }

    public String getGatewayInstanceArn() {
        return this.gatewayInstanceArn;
    }

    public GatewayInstance withGatewayInstanceArn(String gatewayInstanceArn) {
        this.setGatewayInstanceArn(gatewayInstanceArn);
        return this;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public GatewayInstance withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public List<MessageDetail> getInstanceMessages() {
        return this.instanceMessages;
    }

    public void setInstanceMessages(Collection<MessageDetail> instanceMessages) {
        if (instanceMessages == null) {
            this.instanceMessages = null;
            return;
        }
        this.instanceMessages = new ArrayList<MessageDetail>(instanceMessages);
    }

    public GatewayInstance withInstanceMessages(MessageDetail ... instanceMessages) {
        if (this.instanceMessages == null) {
            this.setInstanceMessages(new ArrayList<MessageDetail>(instanceMessages.length));
        }
        for (MessageDetail ele : instanceMessages) {
            this.instanceMessages.add(ele);
        }
        return this;
    }

    public GatewayInstance withInstanceMessages(Collection<MessageDetail> instanceMessages) {
        this.setInstanceMessages(instanceMessages);
        return this;
    }

    public void setInstanceState(String instanceState) {
        this.instanceState = instanceState;
    }

    public String getInstanceState() {
        return this.instanceState;
    }

    public GatewayInstance withInstanceState(String instanceState) {
        this.setInstanceState(instanceState);
        return this;
    }

    public GatewayInstance withInstanceState(InstanceState instanceState) {
        this.instanceState = instanceState.toString();
        return this;
    }

    public void setRunningBridgeCount(Integer runningBridgeCount) {
        this.runningBridgeCount = runningBridgeCount;
    }

    public Integer getRunningBridgeCount() {
        return this.runningBridgeCount;
    }

    public GatewayInstance withRunningBridgeCount(Integer runningBridgeCount) {
        this.setRunningBridgeCount(runningBridgeCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBridgePlacement() != null) {
            sb.append("BridgePlacement: ").append(this.getBridgePlacement()).append(",");
        }
        if (this.getConnectionStatus() != null) {
            sb.append("ConnectionStatus: ").append(this.getConnectionStatus()).append(",");
        }
        if (this.getGatewayArn() != null) {
            sb.append("GatewayArn: ").append(this.getGatewayArn()).append(",");
        }
        if (this.getGatewayInstanceArn() != null) {
            sb.append("GatewayInstanceArn: ").append(this.getGatewayInstanceArn()).append(",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getInstanceMessages() != null) {
            sb.append("InstanceMessages: ").append(this.getInstanceMessages()).append(",");
        }
        if (this.getInstanceState() != null) {
            sb.append("InstanceState: ").append(this.getInstanceState()).append(",");
        }
        if (this.getRunningBridgeCount() != null) {
            sb.append("RunningBridgeCount: ").append(this.getRunningBridgeCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewayInstance)) {
            return false;
        }
        GatewayInstance other = (GatewayInstance)obj;
        if (other.getBridgePlacement() == null ^ this.getBridgePlacement() == null) {
            return false;
        }
        if (other.getBridgePlacement() != null && !other.getBridgePlacement().equals(this.getBridgePlacement())) {
            return false;
        }
        if (other.getConnectionStatus() == null ^ this.getConnectionStatus() == null) {
            return false;
        }
        if (other.getConnectionStatus() != null && !other.getConnectionStatus().equals(this.getConnectionStatus())) {
            return false;
        }
        if (other.getGatewayArn() == null ^ this.getGatewayArn() == null) {
            return false;
        }
        if (other.getGatewayArn() != null && !other.getGatewayArn().equals(this.getGatewayArn())) {
            return false;
        }
        if (other.getGatewayInstanceArn() == null ^ this.getGatewayInstanceArn() == null) {
            return false;
        }
        if (other.getGatewayInstanceArn() != null && !other.getGatewayInstanceArn().equals(this.getGatewayInstanceArn())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getInstanceMessages() == null ^ this.getInstanceMessages() == null) {
            return false;
        }
        if (other.getInstanceMessages() != null && !other.getInstanceMessages().equals(this.getInstanceMessages())) {
            return false;
        }
        if (other.getInstanceState() == null ^ this.getInstanceState() == null) {
            return false;
        }
        if (other.getInstanceState() != null && !other.getInstanceState().equals(this.getInstanceState())) {
            return false;
        }
        if (other.getRunningBridgeCount() == null ^ this.getRunningBridgeCount() == null) {
            return false;
        }
        return other.getRunningBridgeCount() == null || other.getRunningBridgeCount().equals(this.getRunningBridgeCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBridgePlacement() == null ? 0 : this.getBridgePlacement().hashCode());
        hashCode = 31 * hashCode + (this.getConnectionStatus() == null ? 0 : this.getConnectionStatus().hashCode());
        hashCode = 31 * hashCode + (this.getGatewayArn() == null ? 0 : this.getGatewayArn().hashCode());
        hashCode = 31 * hashCode + (this.getGatewayInstanceArn() == null ? 0 : this.getGatewayInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceMessages() == null ? 0 : this.getInstanceMessages().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceState() == null ? 0 : this.getInstanceState().hashCode());
        hashCode = 31 * hashCode + (this.getRunningBridgeCount() == null ? 0 : this.getRunningBridgeCount().hashCode());
        return hashCode;
    }

    public GatewayInstance clone() {
        try {
            return (GatewayInstance)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GatewayInstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

