/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gluedatabrew.model.DatasetParameter;
import com.amazonaws.services.gluedatabrew.model.FilesLimit;
import com.amazonaws.services.gluedatabrew.model.FilterExpression;
import com.amazonaws.services.gluedatabrew.model.transform.PathOptionsMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PathOptions
implements Serializable,
Cloneable,
StructuredPojo {
    private FilterExpression lastModifiedDateCondition;
    private FilesLimit filesLimit;
    private Map<String, DatasetParameter> parameters;

    public void setLastModifiedDateCondition(FilterExpression lastModifiedDateCondition) {
        this.lastModifiedDateCondition = lastModifiedDateCondition;
    }

    public FilterExpression getLastModifiedDateCondition() {
        return this.lastModifiedDateCondition;
    }

    public PathOptions withLastModifiedDateCondition(FilterExpression lastModifiedDateCondition) {
        this.setLastModifiedDateCondition(lastModifiedDateCondition);
        return this;
    }

    public void setFilesLimit(FilesLimit filesLimit) {
        this.filesLimit = filesLimit;
    }

    public FilesLimit getFilesLimit() {
        return this.filesLimit;
    }

    public PathOptions withFilesLimit(FilesLimit filesLimit) {
        this.setFilesLimit(filesLimit);
        return this;
    }

    public Map<String, DatasetParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, DatasetParameter> parameters) {
        this.parameters = parameters;
    }

    public PathOptions withParameters(Map<String, DatasetParameter> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public PathOptions addParametersEntry(String key, DatasetParameter value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, DatasetParameter>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public PathOptions clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLastModifiedDateCondition() != null) {
            sb.append("LastModifiedDateCondition: ").append(this.getLastModifiedDateCondition()).append(",");
        }
        if (this.getFilesLimit() != null) {
            sb.append("FilesLimit: ").append(this.getFilesLimit()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathOptions)) {
            return false;
        }
        PathOptions other = (PathOptions)obj;
        if (other.getLastModifiedDateCondition() == null ^ this.getLastModifiedDateCondition() == null) {
            return false;
        }
        if (other.getLastModifiedDateCondition() != null && !other.getLastModifiedDateCondition().equals(this.getLastModifiedDateCondition())) {
            return false;
        }
        if (other.getFilesLimit() == null ^ this.getFilesLimit() == null) {
            return false;
        }
        if (other.getFilesLimit() != null && !other.getFilesLimit().equals(this.getFilesLimit())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLastModifiedDateCondition() == null ? 0 : this.getLastModifiedDateCondition().hashCode());
        hashCode = 31 * hashCode + (this.getFilesLimit() == null ? 0 : this.getFilesLimit().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public PathOptions clone() {
        try {
            return (PathOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PathOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

