/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.emrserverless.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.emrserverless.model.Architecture;
import com.amazonaws.services.emrserverless.model.AutoStartConfig;
import com.amazonaws.services.emrserverless.model.AutoStopConfig;
import com.amazonaws.services.emrserverless.model.Configuration;
import com.amazonaws.services.emrserverless.model.ImageConfigurationInput;
import com.amazonaws.services.emrserverless.model.InitialCapacityConfig;
import com.amazonaws.services.emrserverless.model.InteractiveConfiguration;
import com.amazonaws.services.emrserverless.model.MaximumAllowedResources;
import com.amazonaws.services.emrserverless.model.MonitoringConfiguration;
import com.amazonaws.services.emrserverless.model.NetworkConfiguration;
import com.amazonaws.services.emrserverless.model.WorkerTypeSpecificationInput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateApplicationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String releaseLabel;
    private String type;
    private String clientToken;
    private Map<String, InitialCapacityConfig> initialCapacity;
    private MaximumAllowedResources maximumCapacity;
    private Map<String, String> tags;
    private AutoStartConfig autoStartConfiguration;
    private AutoStopConfig autoStopConfiguration;
    private NetworkConfiguration networkConfiguration;
    private String architecture;
    private ImageConfigurationInput imageConfiguration;
    private Map<String, WorkerTypeSpecificationInput> workerTypeSpecifications;
    private List<Configuration> runtimeConfiguration;
    private MonitoringConfiguration monitoringConfiguration;
    private InteractiveConfiguration interactiveConfiguration;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateApplicationRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setReleaseLabel(String releaseLabel) {
        this.releaseLabel = releaseLabel;
    }

    public String getReleaseLabel() {
        return this.releaseLabel;
    }

    public CreateApplicationRequest withReleaseLabel(String releaseLabel) {
        this.setReleaseLabel(releaseLabel);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public CreateApplicationRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateApplicationRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public Map<String, InitialCapacityConfig> getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setInitialCapacity(Map<String, InitialCapacityConfig> initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public CreateApplicationRequest withInitialCapacity(Map<String, InitialCapacityConfig> initialCapacity) {
        this.setInitialCapacity(initialCapacity);
        return this;
    }

    public CreateApplicationRequest addInitialCapacityEntry(String key, InitialCapacityConfig value) {
        if (null == this.initialCapacity) {
            this.initialCapacity = new HashMap<String, InitialCapacityConfig>();
        }
        if (this.initialCapacity.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.initialCapacity.put(key, value);
        return this;
    }

    public CreateApplicationRequest clearInitialCapacityEntries() {
        this.initialCapacity = null;
        return this;
    }

    public void setMaximumCapacity(MaximumAllowedResources maximumCapacity) {
        this.maximumCapacity = maximumCapacity;
    }

    public MaximumAllowedResources getMaximumCapacity() {
        return this.maximumCapacity;
    }

    public CreateApplicationRequest withMaximumCapacity(MaximumAllowedResources maximumCapacity) {
        this.setMaximumCapacity(maximumCapacity);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateApplicationRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateApplicationRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateApplicationRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setAutoStartConfiguration(AutoStartConfig autoStartConfiguration) {
        this.autoStartConfiguration = autoStartConfiguration;
    }

    public AutoStartConfig getAutoStartConfiguration() {
        return this.autoStartConfiguration;
    }

    public CreateApplicationRequest withAutoStartConfiguration(AutoStartConfig autoStartConfiguration) {
        this.setAutoStartConfiguration(autoStartConfiguration);
        return this;
    }

    public void setAutoStopConfiguration(AutoStopConfig autoStopConfiguration) {
        this.autoStopConfiguration = autoStopConfiguration;
    }

    public AutoStopConfig getAutoStopConfiguration() {
        return this.autoStopConfiguration;
    }

    public CreateApplicationRequest withAutoStopConfiguration(AutoStopConfig autoStopConfiguration) {
        this.setAutoStopConfiguration(autoStopConfiguration);
        return this;
    }

    public void setNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public CreateApplicationRequest withNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.setNetworkConfiguration(networkConfiguration);
        return this;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public CreateApplicationRequest withArchitecture(String architecture) {
        this.setArchitecture(architecture);
        return this;
    }

    public CreateApplicationRequest withArchitecture(Architecture architecture) {
        this.architecture = architecture.toString();
        return this;
    }

    public void setImageConfiguration(ImageConfigurationInput imageConfiguration) {
        this.imageConfiguration = imageConfiguration;
    }

    public ImageConfigurationInput getImageConfiguration() {
        return this.imageConfiguration;
    }

    public CreateApplicationRequest withImageConfiguration(ImageConfigurationInput imageConfiguration) {
        this.setImageConfiguration(imageConfiguration);
        return this;
    }

    public Map<String, WorkerTypeSpecificationInput> getWorkerTypeSpecifications() {
        return this.workerTypeSpecifications;
    }

    public void setWorkerTypeSpecifications(Map<String, WorkerTypeSpecificationInput> workerTypeSpecifications) {
        this.workerTypeSpecifications = workerTypeSpecifications;
    }

    public CreateApplicationRequest withWorkerTypeSpecifications(Map<String, WorkerTypeSpecificationInput> workerTypeSpecifications) {
        this.setWorkerTypeSpecifications(workerTypeSpecifications);
        return this;
    }

    public CreateApplicationRequest addWorkerTypeSpecificationsEntry(String key, WorkerTypeSpecificationInput value) {
        if (null == this.workerTypeSpecifications) {
            this.workerTypeSpecifications = new HashMap<String, WorkerTypeSpecificationInput>();
        }
        if (this.workerTypeSpecifications.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.workerTypeSpecifications.put(key, value);
        return this;
    }

    public CreateApplicationRequest clearWorkerTypeSpecificationsEntries() {
        this.workerTypeSpecifications = null;
        return this;
    }

    public List<Configuration> getRuntimeConfiguration() {
        return this.runtimeConfiguration;
    }

    public void setRuntimeConfiguration(Collection<Configuration> runtimeConfiguration) {
        if (runtimeConfiguration == null) {
            this.runtimeConfiguration = null;
            return;
        }
        this.runtimeConfiguration = new ArrayList<Configuration>(runtimeConfiguration);
    }

    public CreateApplicationRequest withRuntimeConfiguration(Configuration ... runtimeConfiguration) {
        if (this.runtimeConfiguration == null) {
            this.setRuntimeConfiguration(new ArrayList<Configuration>(runtimeConfiguration.length));
        }
        for (Configuration ele : runtimeConfiguration) {
            this.runtimeConfiguration.add(ele);
        }
        return this;
    }

    public CreateApplicationRequest withRuntimeConfiguration(Collection<Configuration> runtimeConfiguration) {
        this.setRuntimeConfiguration(runtimeConfiguration);
        return this;
    }

    public void setMonitoringConfiguration(MonitoringConfiguration monitoringConfiguration) {
        this.monitoringConfiguration = monitoringConfiguration;
    }

    public MonitoringConfiguration getMonitoringConfiguration() {
        return this.monitoringConfiguration;
    }

    public CreateApplicationRequest withMonitoringConfiguration(MonitoringConfiguration monitoringConfiguration) {
        this.setMonitoringConfiguration(monitoringConfiguration);
        return this;
    }

    public void setInteractiveConfiguration(InteractiveConfiguration interactiveConfiguration) {
        this.interactiveConfiguration = interactiveConfiguration;
    }

    public InteractiveConfiguration getInteractiveConfiguration() {
        return this.interactiveConfiguration;
    }

    public CreateApplicationRequest withInteractiveConfiguration(InteractiveConfiguration interactiveConfiguration) {
        this.setInteractiveConfiguration(interactiveConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getReleaseLabel() != null) {
            sb.append("ReleaseLabel: ").append(this.getReleaseLabel()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getInitialCapacity() != null) {
            sb.append("InitialCapacity: ").append(this.getInitialCapacity()).append(",");
        }
        if (this.getMaximumCapacity() != null) {
            sb.append("MaximumCapacity: ").append(this.getMaximumCapacity()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getAutoStartConfiguration() != null) {
            sb.append("AutoStartConfiguration: ").append(this.getAutoStartConfiguration()).append(",");
        }
        if (this.getAutoStopConfiguration() != null) {
            sb.append("AutoStopConfiguration: ").append(this.getAutoStopConfiguration()).append(",");
        }
        if (this.getNetworkConfiguration() != null) {
            sb.append("NetworkConfiguration: ").append(this.getNetworkConfiguration()).append(",");
        }
        if (this.getArchitecture() != null) {
            sb.append("Architecture: ").append(this.getArchitecture()).append(",");
        }
        if (this.getImageConfiguration() != null) {
            sb.append("ImageConfiguration: ").append(this.getImageConfiguration()).append(",");
        }
        if (this.getWorkerTypeSpecifications() != null) {
            sb.append("WorkerTypeSpecifications: ").append(this.getWorkerTypeSpecifications()).append(",");
        }
        if (this.getRuntimeConfiguration() != null) {
            sb.append("RuntimeConfiguration: ").append(this.getRuntimeConfiguration()).append(",");
        }
        if (this.getMonitoringConfiguration() != null) {
            sb.append("MonitoringConfiguration: ").append(this.getMonitoringConfiguration()).append(",");
        }
        if (this.getInteractiveConfiguration() != null) {
            sb.append("InteractiveConfiguration: ").append(this.getInteractiveConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getReleaseLabel() == null ^ this.getReleaseLabel() == null) {
            return false;
        }
        if (other.getReleaseLabel() != null && !other.getReleaseLabel().equals(this.getReleaseLabel())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getInitialCapacity() == null ^ this.getInitialCapacity() == null) {
            return false;
        }
        if (other.getInitialCapacity() != null && !other.getInitialCapacity().equals(this.getInitialCapacity())) {
            return false;
        }
        if (other.getMaximumCapacity() == null ^ this.getMaximumCapacity() == null) {
            return false;
        }
        if (other.getMaximumCapacity() != null && !other.getMaximumCapacity().equals(this.getMaximumCapacity())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getAutoStartConfiguration() == null ^ this.getAutoStartConfiguration() == null) {
            return false;
        }
        if (other.getAutoStartConfiguration() != null && !other.getAutoStartConfiguration().equals(this.getAutoStartConfiguration())) {
            return false;
        }
        if (other.getAutoStopConfiguration() == null ^ this.getAutoStopConfiguration() == null) {
            return false;
        }
        if (other.getAutoStopConfiguration() != null && !other.getAutoStopConfiguration().equals(this.getAutoStopConfiguration())) {
            return false;
        }
        if (other.getNetworkConfiguration() == null ^ this.getNetworkConfiguration() == null) {
            return false;
        }
        if (other.getNetworkConfiguration() != null && !other.getNetworkConfiguration().equals(this.getNetworkConfiguration())) {
            return false;
        }
        if (other.getArchitecture() == null ^ this.getArchitecture() == null) {
            return false;
        }
        if (other.getArchitecture() != null && !other.getArchitecture().equals(this.getArchitecture())) {
            return false;
        }
        if (other.getImageConfiguration() == null ^ this.getImageConfiguration() == null) {
            return false;
        }
        if (other.getImageConfiguration() != null && !other.getImageConfiguration().equals(this.getImageConfiguration())) {
            return false;
        }
        if (other.getWorkerTypeSpecifications() == null ^ this.getWorkerTypeSpecifications() == null) {
            return false;
        }
        if (other.getWorkerTypeSpecifications() != null && !other.getWorkerTypeSpecifications().equals(this.getWorkerTypeSpecifications())) {
            return false;
        }
        if (other.getRuntimeConfiguration() == null ^ this.getRuntimeConfiguration() == null) {
            return false;
        }
        if (other.getRuntimeConfiguration() != null && !other.getRuntimeConfiguration().equals(this.getRuntimeConfiguration())) {
            return false;
        }
        if (other.getMonitoringConfiguration() == null ^ this.getMonitoringConfiguration() == null) {
            return false;
        }
        if (other.getMonitoringConfiguration() != null && !other.getMonitoringConfiguration().equals(this.getMonitoringConfiguration())) {
            return false;
        }
        if (other.getInteractiveConfiguration() == null ^ this.getInteractiveConfiguration() == null) {
            return false;
        }
        return other.getInteractiveConfiguration() == null || other.getInteractiveConfiguration().equals(this.getInteractiveConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getReleaseLabel() == null ? 0 : this.getReleaseLabel().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getInitialCapacity() == null ? 0 : this.getInitialCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getMaximumCapacity() == null ? 0 : this.getMaximumCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getAutoStartConfiguration() == null ? 0 : this.getAutoStartConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getAutoStopConfiguration() == null ? 0 : this.getAutoStopConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkConfiguration() == null ? 0 : this.getNetworkConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getArchitecture() == null ? 0 : this.getArchitecture().hashCode());
        hashCode = 31 * hashCode + (this.getImageConfiguration() == null ? 0 : this.getImageConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getWorkerTypeSpecifications() == null ? 0 : this.getWorkerTypeSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getRuntimeConfiguration() == null ? 0 : this.getRuntimeConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoringConfiguration() == null ? 0 : this.getMonitoringConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getInteractiveConfiguration() == null ? 0 : this.getInteractiveConfiguration().hashCode());
        return hashCode;
    }

    public CreateApplicationRequest clone() {
        return (CreateApplicationRequest)super.clone();
    }
}

