/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elastictranscoder.model.Permission;

public class PermissionJsonMarshaller {
    private static PermissionJsonMarshaller instance;

    public void marshall(Permission permission, StructuredJsonGenerator jsonGenerator) {
        if (permission == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList accessList;
            jsonGenerator.writeStartObject();
            if (permission.getGranteeType() != null) {
                jsonGenerator.writeFieldName("GranteeType").writeValue(permission.getGranteeType());
            }
            if (permission.getGrantee() != null) {
                jsonGenerator.writeFieldName("Grantee").writeValue(permission.getGrantee());
            }
            if (!(accessList = (SdkInternalList)permission.getAccess()).isEmpty() || !accessList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Access");
                jsonGenerator.writeStartArray();
                for (String accessListValue : accessList) {
                    if (accessListValue == null) continue;
                    jsonGenerator.writeValue(accessListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PermissionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PermissionJsonMarshaller();
        }
        return instance;
    }
}

