/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.devopsguru.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Represents the health of an Amazon Web Services service.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ServiceHealth" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ServiceHealth implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the Amazon Web Services service.
     * </p>
     */
    private String serviceName;
    /**
     * <p>
     * Represents the health of an Amazon Web Services service. This is a <code>ServiceInsightHealth</code> that
     * contains the number of open proactive and reactive insights for this service.
     * </p>
     */
    private ServiceInsightHealth insight;
    /**
     * <p>
     * Number of resources that DevOps Guru is monitoring in an analyzed Amazon Web Services service.
     * </p>
     */
    private Long analyzedResourceCount;

    /**
     * <p>
     * The name of the Amazon Web Services service.
     * </p>
     * 
     * @param serviceName
     *        The name of the Amazon Web Services service.
     * @see ServiceName
     */

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    /**
     * <p>
     * The name of the Amazon Web Services service.
     * </p>
     * 
     * @return The name of the Amazon Web Services service.
     * @see ServiceName
     */

    public String getServiceName() {
        return this.serviceName;
    }

    /**
     * <p>
     * The name of the Amazon Web Services service.
     * </p>
     * 
     * @param serviceName
     *        The name of the Amazon Web Services service.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ServiceName
     */

    public ServiceHealth withServiceName(String serviceName) {
        setServiceName(serviceName);
        return this;
    }

    /**
     * <p>
     * The name of the Amazon Web Services service.
     * </p>
     * 
     * @param serviceName
     *        The name of the Amazon Web Services service.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ServiceName
     */

    public ServiceHealth withServiceName(ServiceName serviceName) {
        this.serviceName = serviceName.toString();
        return this;
    }

    /**
     * <p>
     * Represents the health of an Amazon Web Services service. This is a <code>ServiceInsightHealth</code> that
     * contains the number of open proactive and reactive insights for this service.
     * </p>
     * 
     * @param insight
     *        Represents the health of an Amazon Web Services service. This is a <code>ServiceInsightHealth</code> that
     *        contains the number of open proactive and reactive insights for this service.
     */

    public void setInsight(ServiceInsightHealth insight) {
        this.insight = insight;
    }

    /**
     * <p>
     * Represents the health of an Amazon Web Services service. This is a <code>ServiceInsightHealth</code> that
     * contains the number of open proactive and reactive insights for this service.
     * </p>
     * 
     * @return Represents the health of an Amazon Web Services service. This is a <code>ServiceInsightHealth</code> that
     *         contains the number of open proactive and reactive insights for this service.
     */

    public ServiceInsightHealth getInsight() {
        return this.insight;
    }

    /**
     * <p>
     * Represents the health of an Amazon Web Services service. This is a <code>ServiceInsightHealth</code> that
     * contains the number of open proactive and reactive insights for this service.
     * </p>
     * 
     * @param insight
     *        Represents the health of an Amazon Web Services service. This is a <code>ServiceInsightHealth</code> that
     *        contains the number of open proactive and reactive insights for this service.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ServiceHealth withInsight(ServiceInsightHealth insight) {
        setInsight(insight);
        return this;
    }

    /**
     * <p>
     * Number of resources that DevOps Guru is monitoring in an analyzed Amazon Web Services service.
     * </p>
     * 
     * @param analyzedResourceCount
     *        Number of resources that DevOps Guru is monitoring in an analyzed Amazon Web Services service.
     */

    public void setAnalyzedResourceCount(Long analyzedResourceCount) {
        this.analyzedResourceCount = analyzedResourceCount;
    }

    /**
     * <p>
     * Number of resources that DevOps Guru is monitoring in an analyzed Amazon Web Services service.
     * </p>
     * 
     * @return Number of resources that DevOps Guru is monitoring in an analyzed Amazon Web Services service.
     */

    public Long getAnalyzedResourceCount() {
        return this.analyzedResourceCount;
    }

    /**
     * <p>
     * Number of resources that DevOps Guru is monitoring in an analyzed Amazon Web Services service.
     * </p>
     * 
     * @param analyzedResourceCount
     *        Number of resources that DevOps Guru is monitoring in an analyzed Amazon Web Services service.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ServiceHealth withAnalyzedResourceCount(Long analyzedResourceCount) {
        setAnalyzedResourceCount(analyzedResourceCount);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getServiceName() != null)
            sb.append("ServiceName: ").append(getServiceName()).append(",");
        if (getInsight() != null)
            sb.append("Insight: ").append(getInsight()).append(",");
        if (getAnalyzedResourceCount() != null)
            sb.append("AnalyzedResourceCount: ").append(getAnalyzedResourceCount());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ServiceHealth == false)
            return false;
        ServiceHealth other = (ServiceHealth) obj;
        if (other.getServiceName() == null ^ this.getServiceName() == null)
            return false;
        if (other.getServiceName() != null && other.getServiceName().equals(this.getServiceName()) == false)
            return false;
        if (other.getInsight() == null ^ this.getInsight() == null)
            return false;
        if (other.getInsight() != null && other.getInsight().equals(this.getInsight()) == false)
            return false;
        if (other.getAnalyzedResourceCount() == null ^ this.getAnalyzedResourceCount() == null)
            return false;
        if (other.getAnalyzedResourceCount() != null && other.getAnalyzedResourceCount().equals(this.getAnalyzedResourceCount()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getServiceName() == null) ? 0 : getServiceName().hashCode());
        hashCode = prime * hashCode + ((getInsight() == null) ? 0 : getInsight().hashCode());
        hashCode = prime * hashCode + ((getAnalyzedResourceCount() == null) ? 0 : getAnalyzedResourceCount().hashCode());
        return hashCode;
    }

    @Override
    public ServiceHealth clone() {
        try {
            return (ServiceHealth) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.devopsguru.model.transform.ServiceHealthMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
