/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connectcases.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Object for field Options errors.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/FieldOptionError" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class FieldOptionError implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Error code from creating or updating field option.
     * </p>
     */
    private String errorCode;
    /**
     * <p>
     * Error message from creating or updating field option.
     * </p>
     */
    private String message;
    /**
     * <p>
     * The field option value that caused the error.
     * </p>
     */
    private String value;

    /**
     * <p>
     * Error code from creating or updating field option.
     * </p>
     * 
     * @param errorCode
     *        Error code from creating or updating field option.
     */

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    /**
     * <p>
     * Error code from creating or updating field option.
     * </p>
     * 
     * @return Error code from creating or updating field option.
     */

    public String getErrorCode() {
        return this.errorCode;
    }

    /**
     * <p>
     * Error code from creating or updating field option.
     * </p>
     * 
     * @param errorCode
     *        Error code from creating or updating field option.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FieldOptionError withErrorCode(String errorCode) {
        setErrorCode(errorCode);
        return this;
    }

    /**
     * <p>
     * Error message from creating or updating field option.
     * </p>
     * 
     * @param message
     *        Error message from creating or updating field option.
     */

    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * <p>
     * Error message from creating or updating field option.
     * </p>
     * 
     * @return Error message from creating or updating field option.
     */

    public String getMessage() {
        return this.message;
    }

    /**
     * <p>
     * Error message from creating or updating field option.
     * </p>
     * 
     * @param message
     *        Error message from creating or updating field option.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FieldOptionError withMessage(String message) {
        setMessage(message);
        return this;
    }

    /**
     * <p>
     * The field option value that caused the error.
     * </p>
     * 
     * @param value
     *        The field option value that caused the error.
     */

    public void setValue(String value) {
        this.value = value;
    }

    /**
     * <p>
     * The field option value that caused the error.
     * </p>
     * 
     * @return The field option value that caused the error.
     */

    public String getValue() {
        return this.value;
    }

    /**
     * <p>
     * The field option value that caused the error.
     * </p>
     * 
     * @param value
     *        The field option value that caused the error.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FieldOptionError withValue(String value) {
        setValue(value);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getErrorCode() != null)
            sb.append("ErrorCode: ").append(getErrorCode()).append(",");
        if (getMessage() != null)
            sb.append("Message: ").append(getMessage()).append(",");
        if (getValue() != null)
            sb.append("Value: ").append(getValue());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof FieldOptionError == false)
            return false;
        FieldOptionError other = (FieldOptionError) obj;
        if (other.getErrorCode() == null ^ this.getErrorCode() == null)
            return false;
        if (other.getErrorCode() != null && other.getErrorCode().equals(this.getErrorCode()) == false)
            return false;
        if (other.getMessage() == null ^ this.getMessage() == null)
            return false;
        if (other.getMessage() != null && other.getMessage().equals(this.getMessage()) == false)
            return false;
        if (other.getValue() == null ^ this.getValue() == null)
            return false;
        if (other.getValue() != null && other.getValue().equals(this.getValue()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getErrorCode() == null) ? 0 : getErrorCode().hashCode());
        hashCode = prime * hashCode + ((getMessage() == null) ? 0 : getMessage().hashCode());
        hashCode = prime * hashCode + ((getValue() == null) ? 0 : getValue().hashCode());
        return hashCode;
    }

    @Override
    public FieldOptionError clone() {
        try {
            return (FieldOptionError) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.connectcases.model.transform.FieldOptionErrorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
