/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.computeoptimizer.AWSComputeOptimizerAsync;
import com.amazonaws.services.computeoptimizer.AWSComputeOptimizerAsyncClientBuilder;
import com.amazonaws.services.computeoptimizer.AWSComputeOptimizerClient;
import com.amazonaws.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.GetEC2InstanceRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.GetEC2InstanceRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.GetEC2RecommendationProjectedMetricsRequest;
import com.amazonaws.services.computeoptimizer.model.GetEC2RecommendationProjectedMetricsResult;
import com.amazonaws.services.computeoptimizer.model.GetEnrollmentStatusRequest;
import com.amazonaws.services.computeoptimizer.model.GetEnrollmentStatusResult;
import com.amazonaws.services.computeoptimizer.model.GetRecommendationSummariesRequest;
import com.amazonaws.services.computeoptimizer.model.GetRecommendationSummariesResult;
import com.amazonaws.services.computeoptimizer.model.UpdateEnrollmentStatusRequest;
import com.amazonaws.services.computeoptimizer.model.UpdateEnrollmentStatusResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSComputeOptimizerAsyncClient
extends AWSComputeOptimizerClient
implements AWSComputeOptimizerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSComputeOptimizerAsyncClientBuilder asyncBuilder() {
        return AWSComputeOptimizerAsyncClientBuilder.standard();
    }

    AWSComputeOptimizerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetAutoScalingGroupRecommendationsResult> getAutoScalingGroupRecommendationsAsync(GetAutoScalingGroupRecommendationsRequest request) {
        return this.getAutoScalingGroupRecommendationsAsync(request, null);
    }

    @Override
    public Future<GetAutoScalingGroupRecommendationsResult> getAutoScalingGroupRecommendationsAsync(GetAutoScalingGroupRecommendationsRequest request, final AsyncHandler<GetAutoScalingGroupRecommendationsRequest, GetAutoScalingGroupRecommendationsResult> asyncHandler) {
        final GetAutoScalingGroupRecommendationsRequest finalRequest = (GetAutoScalingGroupRecommendationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAutoScalingGroupRecommendationsResult>(){

            @Override
            public GetAutoScalingGroupRecommendationsResult call() throws Exception {
                GetAutoScalingGroupRecommendationsResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeGetAutoScalingGroupRecommendations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEC2InstanceRecommendationsResult> getEC2InstanceRecommendationsAsync(GetEC2InstanceRecommendationsRequest request) {
        return this.getEC2InstanceRecommendationsAsync(request, null);
    }

    @Override
    public Future<GetEC2InstanceRecommendationsResult> getEC2InstanceRecommendationsAsync(GetEC2InstanceRecommendationsRequest request, final AsyncHandler<GetEC2InstanceRecommendationsRequest, GetEC2InstanceRecommendationsResult> asyncHandler) {
        final GetEC2InstanceRecommendationsRequest finalRequest = (GetEC2InstanceRecommendationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEC2InstanceRecommendationsResult>(){

            @Override
            public GetEC2InstanceRecommendationsResult call() throws Exception {
                GetEC2InstanceRecommendationsResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeGetEC2InstanceRecommendations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEC2RecommendationProjectedMetricsResult> getEC2RecommendationProjectedMetricsAsync(GetEC2RecommendationProjectedMetricsRequest request) {
        return this.getEC2RecommendationProjectedMetricsAsync(request, null);
    }

    @Override
    public Future<GetEC2RecommendationProjectedMetricsResult> getEC2RecommendationProjectedMetricsAsync(GetEC2RecommendationProjectedMetricsRequest request, final AsyncHandler<GetEC2RecommendationProjectedMetricsRequest, GetEC2RecommendationProjectedMetricsResult> asyncHandler) {
        final GetEC2RecommendationProjectedMetricsRequest finalRequest = (GetEC2RecommendationProjectedMetricsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEC2RecommendationProjectedMetricsResult>(){

            @Override
            public GetEC2RecommendationProjectedMetricsResult call() throws Exception {
                GetEC2RecommendationProjectedMetricsResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeGetEC2RecommendationProjectedMetrics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEnrollmentStatusResult> getEnrollmentStatusAsync(GetEnrollmentStatusRequest request) {
        return this.getEnrollmentStatusAsync(request, null);
    }

    @Override
    public Future<GetEnrollmentStatusResult> getEnrollmentStatusAsync(GetEnrollmentStatusRequest request, final AsyncHandler<GetEnrollmentStatusRequest, GetEnrollmentStatusResult> asyncHandler) {
        final GetEnrollmentStatusRequest finalRequest = (GetEnrollmentStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEnrollmentStatusResult>(){

            @Override
            public GetEnrollmentStatusResult call() throws Exception {
                GetEnrollmentStatusResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeGetEnrollmentStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRecommendationSummariesResult> getRecommendationSummariesAsync(GetRecommendationSummariesRequest request) {
        return this.getRecommendationSummariesAsync(request, null);
    }

    @Override
    public Future<GetRecommendationSummariesResult> getRecommendationSummariesAsync(GetRecommendationSummariesRequest request, final AsyncHandler<GetRecommendationSummariesRequest, GetRecommendationSummariesResult> asyncHandler) {
        final GetRecommendationSummariesRequest finalRequest = (GetRecommendationSummariesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRecommendationSummariesResult>(){

            @Override
            public GetRecommendationSummariesResult call() throws Exception {
                GetRecommendationSummariesResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeGetRecommendationSummaries(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateEnrollmentStatusResult> updateEnrollmentStatusAsync(UpdateEnrollmentStatusRequest request) {
        return this.updateEnrollmentStatusAsync(request, null);
    }

    @Override
    public Future<UpdateEnrollmentStatusResult> updateEnrollmentStatusAsync(UpdateEnrollmentStatusRequest request, final AsyncHandler<UpdateEnrollmentStatusRequest, UpdateEnrollmentStatusResult> asyncHandler) {
        final UpdateEnrollmentStatusRequest finalRequest = (UpdateEnrollmentStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateEnrollmentStatusResult>(){

            @Override
            public UpdateEnrollmentStatusResult call() throws Exception {
                UpdateEnrollmentStatusResult result = null;
                try {
                    result = AWSComputeOptimizerAsyncClient.this.executeUpdateEnrollmentStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

