/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cleanrooms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cleanrooms.model.MemberAbility;
import com.amazonaws.services.cleanrooms.model.MemberStatus;
import com.amazonaws.services.cleanrooms.model.PaymentConfiguration;
import com.amazonaws.services.cleanrooms.model.transform.MemberSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class MemberSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String accountId;
    private String status;
    private String displayName;
    private List<String> abilities;
    private Date createTime;
    private Date updateTime;
    private String membershipId;
    private String membershipArn;
    private PaymentConfiguration paymentConfiguration;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public MemberSummary withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public MemberSummary withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public MemberSummary withStatus(MemberStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public MemberSummary withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public List<String> getAbilities() {
        return this.abilities;
    }

    public void setAbilities(Collection<String> abilities) {
        if (abilities == null) {
            this.abilities = null;
            return;
        }
        this.abilities = new ArrayList<String>(abilities);
    }

    public MemberSummary withAbilities(String ... abilities) {
        if (this.abilities == null) {
            this.setAbilities(new ArrayList<String>(abilities.length));
        }
        for (String ele : abilities) {
            this.abilities.add(ele);
        }
        return this;
    }

    public MemberSummary withAbilities(Collection<String> abilities) {
        this.setAbilities(abilities);
        return this;
    }

    public MemberSummary withAbilities(MemberAbility ... abilities) {
        ArrayList<String> abilitiesCopy = new ArrayList<String>(abilities.length);
        for (MemberAbility value : abilities) {
            abilitiesCopy.add(value.toString());
        }
        if (this.getAbilities() == null) {
            this.setAbilities(abilitiesCopy);
        } else {
            this.getAbilities().addAll(abilitiesCopy);
        }
        return this;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public MemberSummary withCreateTime(Date createTime) {
        this.setCreateTime(createTime);
        return this;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public MemberSummary withUpdateTime(Date updateTime) {
        this.setUpdateTime(updateTime);
        return this;
    }

    public void setMembershipId(String membershipId) {
        this.membershipId = membershipId;
    }

    public String getMembershipId() {
        return this.membershipId;
    }

    public MemberSummary withMembershipId(String membershipId) {
        this.setMembershipId(membershipId);
        return this;
    }

    public void setMembershipArn(String membershipArn) {
        this.membershipArn = membershipArn;
    }

    public String getMembershipArn() {
        return this.membershipArn;
    }

    public MemberSummary withMembershipArn(String membershipArn) {
        this.setMembershipArn(membershipArn);
        return this;
    }

    public void setPaymentConfiguration(PaymentConfiguration paymentConfiguration) {
        this.paymentConfiguration = paymentConfiguration;
    }

    public PaymentConfiguration getPaymentConfiguration() {
        return this.paymentConfiguration;
    }

    public MemberSummary withPaymentConfiguration(PaymentConfiguration paymentConfiguration) {
        this.setPaymentConfiguration(paymentConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getAbilities() != null) {
            sb.append("Abilities: ").append(this.getAbilities()).append(",");
        }
        if (this.getCreateTime() != null) {
            sb.append("CreateTime: ").append(this.getCreateTime()).append(",");
        }
        if (this.getUpdateTime() != null) {
            sb.append("UpdateTime: ").append(this.getUpdateTime()).append(",");
        }
        if (this.getMembershipId() != null) {
            sb.append("MembershipId: ").append(this.getMembershipId()).append(",");
        }
        if (this.getMembershipArn() != null) {
            sb.append("MembershipArn: ").append(this.getMembershipArn()).append(",");
        }
        if (this.getPaymentConfiguration() != null) {
            sb.append("PaymentConfiguration: ").append(this.getPaymentConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberSummary)) {
            return false;
        }
        MemberSummary other = (MemberSummary)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getAbilities() == null ^ this.getAbilities() == null) {
            return false;
        }
        if (other.getAbilities() != null && !other.getAbilities().equals(this.getAbilities())) {
            return false;
        }
        if (other.getCreateTime() == null ^ this.getCreateTime() == null) {
            return false;
        }
        if (other.getCreateTime() != null && !other.getCreateTime().equals(this.getCreateTime())) {
            return false;
        }
        if (other.getUpdateTime() == null ^ this.getUpdateTime() == null) {
            return false;
        }
        if (other.getUpdateTime() != null && !other.getUpdateTime().equals(this.getUpdateTime())) {
            return false;
        }
        if (other.getMembershipId() == null ^ this.getMembershipId() == null) {
            return false;
        }
        if (other.getMembershipId() != null && !other.getMembershipId().equals(this.getMembershipId())) {
            return false;
        }
        if (other.getMembershipArn() == null ^ this.getMembershipArn() == null) {
            return false;
        }
        if (other.getMembershipArn() != null && !other.getMembershipArn().equals(this.getMembershipArn())) {
            return false;
        }
        if (other.getPaymentConfiguration() == null ^ this.getPaymentConfiguration() == null) {
            return false;
        }
        return other.getPaymentConfiguration() == null || other.getPaymentConfiguration().equals(this.getPaymentConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getAbilities() == null ? 0 : this.getAbilities().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTime() == null ? 0 : this.getCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getUpdateTime() == null ? 0 : this.getUpdateTime().hashCode());
        hashCode = 31 * hashCode + (this.getMembershipId() == null ? 0 : this.getMembershipId().hashCode());
        hashCode = 31 * hashCode + (this.getMembershipArn() == null ? 0 : this.getMembershipArn().hashCode());
        hashCode = 31 * hashCode + (this.getPaymentConfiguration() == null ? 0 : this.getPaymentConfiguration().hashCode());
        return hashCode;
    }

    public MemberSummary clone() {
        try {
            return (MemberSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MemberSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

