/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockruntime.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.bedrockruntime.model.GuardrailAction;
import com.amazonaws.services.bedrockruntime.model.GuardrailAssessment;
import com.amazonaws.services.bedrockruntime.model.GuardrailOutputContent;
import com.amazonaws.services.bedrockruntime.model.GuardrailUsage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ApplyGuardrailResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private GuardrailUsage usage;
    private String action;
    private List<GuardrailOutputContent> outputs;
    private List<GuardrailAssessment> assessments;

    public void setUsage(GuardrailUsage usage) {
        this.usage = usage;
    }

    public GuardrailUsage getUsage() {
        return this.usage;
    }

    public ApplyGuardrailResult withUsage(GuardrailUsage usage) {
        this.setUsage(usage);
        return this;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public ApplyGuardrailResult withAction(String action) {
        this.setAction(action);
        return this;
    }

    public ApplyGuardrailResult withAction(GuardrailAction action) {
        this.action = action.toString();
        return this;
    }

    public List<GuardrailOutputContent> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Collection<GuardrailOutputContent> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        this.outputs = new ArrayList<GuardrailOutputContent>(outputs);
    }

    public ApplyGuardrailResult withOutputs(GuardrailOutputContent ... outputs) {
        if (this.outputs == null) {
            this.setOutputs(new ArrayList<GuardrailOutputContent>(outputs.length));
        }
        for (GuardrailOutputContent ele : outputs) {
            this.outputs.add(ele);
        }
        return this;
    }

    public ApplyGuardrailResult withOutputs(Collection<GuardrailOutputContent> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public List<GuardrailAssessment> getAssessments() {
        return this.assessments;
    }

    public void setAssessments(Collection<GuardrailAssessment> assessments) {
        if (assessments == null) {
            this.assessments = null;
            return;
        }
        this.assessments = new ArrayList<GuardrailAssessment>(assessments);
    }

    public ApplyGuardrailResult withAssessments(GuardrailAssessment ... assessments) {
        if (this.assessments == null) {
            this.setAssessments(new ArrayList<GuardrailAssessment>(assessments.length));
        }
        for (GuardrailAssessment ele : assessments) {
            this.assessments.add(ele);
        }
        return this;
    }

    public ApplyGuardrailResult withAssessments(Collection<GuardrailAssessment> assessments) {
        this.setAssessments(assessments);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUsage() != null) {
            sb.append("Usage: ").append(this.getUsage()).append(",");
        }
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: ").append(this.getOutputs()).append(",");
        }
        if (this.getAssessments() != null) {
            sb.append("Assessments: ").append(this.getAssessments());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplyGuardrailResult)) {
            return false;
        }
        ApplyGuardrailResult other = (ApplyGuardrailResult)obj;
        if (other.getUsage() == null ^ this.getUsage() == null) {
            return false;
        }
        if (other.getUsage() != null && !other.getUsage().equals(this.getUsage())) {
            return false;
        }
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !other.getOutputs().equals(this.getOutputs())) {
            return false;
        }
        if (other.getAssessments() == null ^ this.getAssessments() == null) {
            return false;
        }
        return other.getAssessments() == null || other.getAssessments().equals(this.getAssessments());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUsage() == null ? 0 : this.getUsage().hashCode());
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getAssessments() == null ? 0 : this.getAssessments().hashCode());
        return hashCode;
    }

    public ApplyGuardrailResult clone() {
        try {
            return (ApplyGuardrailResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

