/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockagent.model.HierarchicalChunkingLevelConfiguration;
import com.amazonaws.services.bedrockagent.model.transform.HierarchicalChunkingConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HierarchicalChunkingConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<HierarchicalChunkingLevelConfiguration> levelConfigurations;
    private Integer overlapTokens;

    public List<HierarchicalChunkingLevelConfiguration> getLevelConfigurations() {
        return this.levelConfigurations;
    }

    public void setLevelConfigurations(Collection<HierarchicalChunkingLevelConfiguration> levelConfigurations) {
        if (levelConfigurations == null) {
            this.levelConfigurations = null;
            return;
        }
        this.levelConfigurations = new ArrayList<HierarchicalChunkingLevelConfiguration>(levelConfigurations);
    }

    public HierarchicalChunkingConfiguration withLevelConfigurations(HierarchicalChunkingLevelConfiguration ... levelConfigurations) {
        if (this.levelConfigurations == null) {
            this.setLevelConfigurations(new ArrayList<HierarchicalChunkingLevelConfiguration>(levelConfigurations.length));
        }
        for (HierarchicalChunkingLevelConfiguration ele : levelConfigurations) {
            this.levelConfigurations.add(ele);
        }
        return this;
    }

    public HierarchicalChunkingConfiguration withLevelConfigurations(Collection<HierarchicalChunkingLevelConfiguration> levelConfigurations) {
        this.setLevelConfigurations(levelConfigurations);
        return this;
    }

    public void setOverlapTokens(Integer overlapTokens) {
        this.overlapTokens = overlapTokens;
    }

    public Integer getOverlapTokens() {
        return this.overlapTokens;
    }

    public HierarchicalChunkingConfiguration withOverlapTokens(Integer overlapTokens) {
        this.setOverlapTokens(overlapTokens);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLevelConfigurations() != null) {
            sb.append("LevelConfigurations: ").append(this.getLevelConfigurations()).append(",");
        }
        if (this.getOverlapTokens() != null) {
            sb.append("OverlapTokens: ").append(this.getOverlapTokens());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HierarchicalChunkingConfiguration)) {
            return false;
        }
        HierarchicalChunkingConfiguration other = (HierarchicalChunkingConfiguration)obj;
        if (other.getLevelConfigurations() == null ^ this.getLevelConfigurations() == null) {
            return false;
        }
        if (other.getLevelConfigurations() != null && !other.getLevelConfigurations().equals(this.getLevelConfigurations())) {
            return false;
        }
        if (other.getOverlapTokens() == null ^ this.getOverlapTokens() == null) {
            return false;
        }
        return other.getOverlapTokens() == null || other.getOverlapTokens().equals(this.getOverlapTokens());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLevelConfigurations() == null ? 0 : this.getLevelConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getOverlapTokens() == null ? 0 : this.getOverlapTokens().hashCode());
        return hashCode;
    }

    public HierarchicalChunkingConfiguration clone() {
        try {
            return (HierarchicalChunkingConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HierarchicalChunkingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

