/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appregistry.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.appregistry.model.ResourceItemStatus;
import com.amazonaws.services.appregistry.model.ResourceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetAssociatedResourceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String application;
    private String resourceType;
    private String resource;
    private String nextToken;
    private List<String> resourceTagStatus;
    private Integer maxResults;

    public void setApplication(String application) {
        this.application = application;
    }

    public String getApplication() {
        return this.application;
    }

    public GetAssociatedResourceRequest withApplication(String application) {
        this.setApplication(application);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public GetAssociatedResourceRequest withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public GetAssociatedResourceRequest withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return this.resource;
    }

    public GetAssociatedResourceRequest withResource(String resource) {
        this.setResource(resource);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetAssociatedResourceRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<String> getResourceTagStatus() {
        return this.resourceTagStatus;
    }

    public void setResourceTagStatus(Collection<String> resourceTagStatus) {
        if (resourceTagStatus == null) {
            this.resourceTagStatus = null;
            return;
        }
        this.resourceTagStatus = new ArrayList<String>(resourceTagStatus);
    }

    public GetAssociatedResourceRequest withResourceTagStatus(String ... resourceTagStatus) {
        if (this.resourceTagStatus == null) {
            this.setResourceTagStatus(new ArrayList<String>(resourceTagStatus.length));
        }
        for (String ele : resourceTagStatus) {
            this.resourceTagStatus.add(ele);
        }
        return this;
    }

    public GetAssociatedResourceRequest withResourceTagStatus(Collection<String> resourceTagStatus) {
        this.setResourceTagStatus(resourceTagStatus);
        return this;
    }

    public GetAssociatedResourceRequest withResourceTagStatus(ResourceItemStatus ... resourceTagStatus) {
        ArrayList<String> resourceTagStatusCopy = new ArrayList<String>(resourceTagStatus.length);
        for (ResourceItemStatus value : resourceTagStatus) {
            resourceTagStatusCopy.add(value.toString());
        }
        if (this.getResourceTagStatus() == null) {
            this.setResourceTagStatus(resourceTagStatusCopy);
        } else {
            this.getResourceTagStatus().addAll(resourceTagStatusCopy);
        }
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public GetAssociatedResourceRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplication() != null) {
            sb.append("Application: ").append(this.getApplication()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getResource() != null) {
            sb.append("Resource: ").append(this.getResource()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getResourceTagStatus() != null) {
            sb.append("ResourceTagStatus: ").append(this.getResourceTagStatus()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssociatedResourceRequest)) {
            return false;
        }
        GetAssociatedResourceRequest other = (GetAssociatedResourceRequest)obj;
        if (other.getApplication() == null ^ this.getApplication() == null) {
            return false;
        }
        if (other.getApplication() != null && !other.getApplication().equals(this.getApplication())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getResource() == null ^ this.getResource() == null) {
            return false;
        }
        if (other.getResource() != null && !other.getResource().equals(this.getResource())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getResourceTagStatus() == null ^ this.getResourceTagStatus() == null) {
            return false;
        }
        if (other.getResourceTagStatus() != null && !other.getResourceTagStatus().equals(this.getResourceTagStatus())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplication() == null ? 0 : this.getApplication().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getResource() == null ? 0 : this.getResource().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTagStatus() == null ? 0 : this.getResourceTagStatus().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public GetAssociatedResourceRequest clone() {
        return (GetAssociatedResourceRequest)super.clone();
    }
}

