/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appintegrations.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.appintegrations.model.Publication;

@SdkInternalApi
public class PublicationMarshaller {
    private static final MarshallingInfo<String> EVENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Event").build();
    private static final MarshallingInfo<String> SCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Schema").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final PublicationMarshaller instance = new PublicationMarshaller();

    public static PublicationMarshaller getInstance() {
        return instance;
    }

    public void marshall(Publication publication, ProtocolMarshaller protocolMarshaller) {
        if (publication == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)publication.getEvent(), EVENT_BINDING);
            protocolMarshaller.marshall((Object)publication.getSchema(), SCHEMA_BINDING);
            protocolMarshaller.marshall((Object)publication.getDescription(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

