/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplifyuibuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.amplifyuibuilder.model.FieldInputConfig;
import com.amazonaws.services.amplifyuibuilder.model.FieldPosition;
import com.amazonaws.services.amplifyuibuilder.model.FieldValidationConfiguration;
import com.amazonaws.services.amplifyuibuilder.model.transform.FieldConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FieldConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String label;
    private FieldPosition position;
    private Boolean excluded;
    private FieldInputConfig inputType;
    private List<FieldValidationConfiguration> validations;

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public FieldConfig withLabel(String label) {
        this.setLabel(label);
        return this;
    }

    public void setPosition(FieldPosition position) {
        this.position = position;
    }

    public FieldPosition getPosition() {
        return this.position;
    }

    public FieldConfig withPosition(FieldPosition position) {
        this.setPosition(position);
        return this;
    }

    public void setExcluded(Boolean excluded) {
        this.excluded = excluded;
    }

    public Boolean getExcluded() {
        return this.excluded;
    }

    public FieldConfig withExcluded(Boolean excluded) {
        this.setExcluded(excluded);
        return this;
    }

    public Boolean isExcluded() {
        return this.excluded;
    }

    public void setInputType(FieldInputConfig inputType) {
        this.inputType = inputType;
    }

    public FieldInputConfig getInputType() {
        return this.inputType;
    }

    public FieldConfig withInputType(FieldInputConfig inputType) {
        this.setInputType(inputType);
        return this;
    }

    public List<FieldValidationConfiguration> getValidations() {
        return this.validations;
    }

    public void setValidations(Collection<FieldValidationConfiguration> validations) {
        if (validations == null) {
            this.validations = null;
            return;
        }
        this.validations = new ArrayList<FieldValidationConfiguration>(validations);
    }

    public FieldConfig withValidations(FieldValidationConfiguration ... validations) {
        if (this.validations == null) {
            this.setValidations(new ArrayList<FieldValidationConfiguration>(validations.length));
        }
        for (FieldValidationConfiguration ele : validations) {
            this.validations.add(ele);
        }
        return this;
    }

    public FieldConfig withValidations(Collection<FieldValidationConfiguration> validations) {
        this.setValidations(validations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLabel() != null) {
            sb.append("Label: ").append(this.getLabel()).append(",");
        }
        if (this.getPosition() != null) {
            sb.append("Position: ").append(this.getPosition()).append(",");
        }
        if (this.getExcluded() != null) {
            sb.append("Excluded: ").append(this.getExcluded()).append(",");
        }
        if (this.getInputType() != null) {
            sb.append("InputType: ").append(this.getInputType()).append(",");
        }
        if (this.getValidations() != null) {
            sb.append("Validations: ").append(this.getValidations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldConfig)) {
            return false;
        }
        FieldConfig other = (FieldConfig)obj;
        if (other.getLabel() == null ^ this.getLabel() == null) {
            return false;
        }
        if (other.getLabel() != null && !other.getLabel().equals(this.getLabel())) {
            return false;
        }
        if (other.getPosition() == null ^ this.getPosition() == null) {
            return false;
        }
        if (other.getPosition() != null && !other.getPosition().equals(this.getPosition())) {
            return false;
        }
        if (other.getExcluded() == null ^ this.getExcluded() == null) {
            return false;
        }
        if (other.getExcluded() != null && !other.getExcluded().equals(this.getExcluded())) {
            return false;
        }
        if (other.getInputType() == null ^ this.getInputType() == null) {
            return false;
        }
        if (other.getInputType() != null && !other.getInputType().equals(this.getInputType())) {
            return false;
        }
        if (other.getValidations() == null ^ this.getValidations() == null) {
            return false;
        }
        return other.getValidations() == null || other.getValidations().equals(this.getValidations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLabel() == null ? 0 : this.getLabel().hashCode());
        hashCode = 31 * hashCode + (this.getPosition() == null ? 0 : this.getPosition().hashCode());
        hashCode = 31 * hashCode + (this.getExcluded() == null ? 0 : this.getExcluded().hashCode());
        hashCode = 31 * hashCode + (this.getInputType() == null ? 0 : this.getInputType().hashCode());
        hashCode = 31 * hashCode + (this.getValidations() == null ? 0 : this.getValidations().hashCode());
        return hashCode;
    }

    public FieldConfig clone() {
        try {
            return (FieldConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FieldConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

