/*
 * Decompiled with CFR 0.152.
 */
package com.akathist.maven.plugins.launch4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;

public class ClassPath {
    String mainClass;
    boolean addDependencies = true;
    String jarLocation;
    String preCp;
    String postCp;

    private void addToCp(List cp, String cpStr) {
        cp.addAll(Arrays.asList(cpStr.split("\\s*;\\s*")));
    }

    net.sf.launch4j.config.ClassPath toL4j(Set dependencies) {
        net.sf.launch4j.config.ClassPath ret = new net.sf.launch4j.config.ClassPath();
        ret.setMainClass(this.mainClass);
        ArrayList<String> cp = new ArrayList<String>();
        if (this.preCp != null) {
            this.addToCp(cp, this.preCp);
        }
        if (this.addDependencies) {
            if (this.jarLocation == null) {
                this.jarLocation = "";
            } else if (!this.jarLocation.endsWith("/")) {
                this.jarLocation = this.jarLocation + "/";
            }
            for (Artifact dep : dependencies) {
                if (!"compile".equals(dep.getScope()) && !"runtime".equals(dep.getScope())) continue;
                String depFilename = dep.getFile().getName();
                cp.add(this.jarLocation + depFilename);
            }
        }
        if (this.postCp != null) {
            this.addToCp(cp, this.postCp);
        }
        ret.setPaths(cp);
        return ret;
    }
}

